<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvObjectType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об объекте недвижимости
 * @subpackage Structs
 */
class SvedNedvObjectType extends InformationType
{
    /**
     * The cadastralNumber
     * Meta informations extracted from the WSDL
     * - documentation: Кадастровый номер объекта недвижимого имущества | Строка длиной от 1 до 500 символов
     * - minOccurs: 0
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $cadastralNumber;
    /**
     * The conditionalNumber
     * Meta informations extracted from the WSDL
     * - documentation: Условный номер | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $conditionalNumber;
    /**
     * The objectTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа объекта недвижимости | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $objectTypeCode;
    /**
     * The objectTypeText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание типа объекта недвижимости | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $objectTypeText;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование объекта недвижимости | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The assignationCode
     * Meta informations extracted from the WSDL
     * - documentation: Код назначения | По классификатору «Классификатор назначений объектов технического учета» | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $assignationCode;
    /**
     * The assignationName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование назначения | Из «Классификатора назначений объектов технического учета» | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $assignationName;
    /**
     * The assignationText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание назначения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $assignationText;
    /**
     * The groundCategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Целевое назначение (категория) земель | По классификатору «Категории земель» | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $groundCategoryCode;
    /**
     * The groundCategoryText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание целевого назначения(категории) земель | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $groundCategoryText;
    /**
     * The area
     * Meta informations extracted from the WSDL
     * - documentation: Площади
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SvedNedvAreaType[]
     */
    public $area;
    /**
     * Constructor method for SvedNedvObjectType
     * @uses SvedNedvObjectType::setCadastralNumber()
     * @uses SvedNedvObjectType::setConditionalNumber()
     * @uses SvedNedvObjectType::setObjectTypeCode()
     * @uses SvedNedvObjectType::setObjectTypeText()
     * @uses SvedNedvObjectType::setName()
     * @uses SvedNedvObjectType::setAssignationCode()
     * @uses SvedNedvObjectType::setAssignationName()
     * @uses SvedNedvObjectType::setAssignationText()
     * @uses SvedNedvObjectType::setGroundCategoryCode()
     * @uses SvedNedvObjectType::setGroundCategoryText()
     * @uses SvedNedvObjectType::setArea()
     * @param string $cadastralNumber
     * @param string $conditionalNumber
     * @param string $objectTypeCode
     * @param string $objectTypeText
     * @param string $name
     * @param string $assignationCode
     * @param string $assignationName
     * @param string $assignationText
     * @param string $groundCategoryCode
     * @param string $groundCategoryText
     * @param \StructType\SvedNedvAreaType[] $area
     */
    public function __construct($cadastralNumber = null, $conditionalNumber = null, $objectTypeCode = null, $objectTypeText = null, $name = null, $assignationCode = null, $assignationName = null, $assignationText = null, $groundCategoryCode = null, $groundCategoryText = null, array $area = array())
    {
        $this
            ->setCadastralNumber($cadastralNumber)
            ->setConditionalNumber($conditionalNumber)
            ->setObjectTypeCode($objectTypeCode)
            ->setObjectTypeText($objectTypeText)
            ->setName($name)
            ->setAssignationCode($assignationCode)
            ->setAssignationName($assignationName)
            ->setAssignationText($assignationText)
            ->setGroundCategoryCode($groundCategoryCode)
            ->setGroundCategoryText($groundCategoryText)
            ->setArea($area);
    }
    /**
     * Get cadastralNumber value
     * @return string|null
     */
    public function getCadastralNumber()
    {
        return $this->cadastralNumber;
    }
    /**
     * Set cadastralNumber value
     * @param string $cadastralNumber
     * @return \StructType\SvedNedvObjectType
     */
    public function setCadastralNumber($cadastralNumber = null)
    {
        $this->cadastralNumber = $cadastralNumber;
        return $this;
    }
    /**
     * Get conditionalNumber value
     * @return string|null
     */
    public function getConditionalNumber()
    {
        return $this->conditionalNumber;
    }
    /**
     * Set conditionalNumber value
     * @param string $conditionalNumber
     * @return \StructType\SvedNedvObjectType
     */
    public function setConditionalNumber($conditionalNumber = null)
    {
        $this->conditionalNumber = $conditionalNumber;
        return $this;
    }
    /**
     * Get objectTypeCode value
     * @return string|null
     */
    public function getObjectTypeCode()
    {
        return $this->objectTypeCode;
    }
    /**
     * Set objectTypeCode value
     * @param string $objectTypeCode
     * @return \StructType\SvedNedvObjectType
     */
    public function setObjectTypeCode($objectTypeCode = null)
    {
        $this->objectTypeCode = $objectTypeCode;
        return $this;
    }
    /**
     * Get objectTypeText value
     * @return string|null
     */
    public function getObjectTypeText()
    {
        return $this->objectTypeText;
    }
    /**
     * Set objectTypeText value
     * @param string $objectTypeText
     * @return \StructType\SvedNedvObjectType
     */
    public function setObjectTypeText($objectTypeText = null)
    {
        $this->objectTypeText = $objectTypeText;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SvedNedvObjectType
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get assignationCode value
     * @return string|null
     */
    public function getAssignationCode()
    {
        return $this->assignationCode;
    }
    /**
     * Set assignationCode value
     * @param string $assignationCode
     * @return \StructType\SvedNedvObjectType
     */
    public function setAssignationCode($assignationCode = null)
    {
        $this->assignationCode = $assignationCode;
        return $this;
    }
    /**
     * Get assignationName value
     * @return string|null
     */
    public function getAssignationName()
    {
        return $this->assignationName;
    }
    /**
     * Set assignationName value
     * @param string $assignationName
     * @return \StructType\SvedNedvObjectType
     */
    public function setAssignationName($assignationName = null)
    {
        $this->assignationName = $assignationName;
        return $this;
    }
    /**
     * Get assignationText value
     * @return string|null
     */
    public function getAssignationText()
    {
        return $this->assignationText;
    }
    /**
     * Set assignationText value
     * @param string $assignationText
     * @return \StructType\SvedNedvObjectType
     */
    public function setAssignationText($assignationText = null)
    {
        $this->assignationText = $assignationText;
        return $this;
    }
    /**
     * Get groundCategoryCode value
     * @return string|null
     */
    public function getGroundCategoryCode()
    {
        return $this->groundCategoryCode;
    }
    /**
     * Set groundCategoryCode value
     * @param string $groundCategoryCode
     * @return \StructType\SvedNedvObjectType
     */
    public function setGroundCategoryCode($groundCategoryCode = null)
    {
        $this->groundCategoryCode = $groundCategoryCode;
        return $this;
    }
    /**
     * Get groundCategoryText value
     * @return string|null
     */
    public function getGroundCategoryText()
    {
        return $this->groundCategoryText;
    }
    /**
     * Set groundCategoryText value
     * @param string $groundCategoryText
     * @return \StructType\SvedNedvObjectType
     */
    public function setGroundCategoryText($groundCategoryText = null)
    {
        $this->groundCategoryText = $groundCategoryText;
        return $this;
    }
    /**
     * Get area value
     * @return \StructType\SvedNedvAreaType[]|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @throws \InvalidArgumentException
     * @param \StructType\SvedNedvAreaType[] $area
     * @return \StructType\SvedNedvObjectType
     */
    public function setArea(array $area = array())
    {
        $this->area = $area;
        return $this;
    }
    /**
     * Add item to area value
     * @throws \InvalidArgumentException
     * @param \StructType\SvedNedvAreaType $item
     * @return \StructType\SvedNedvObjectType
     */
    public function addToArea(\StructType\SvedNedvAreaType $item)
    {
        $this->area[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SvedNedvObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
