<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvEncumbranceType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об обременениях
 * @subpackage Structs
 */
class SvedNedvEncumbranceType extends InformationType
{
    /**
     * The encCode
     * Meta informations extracted from the WSDL
     * - documentation: Код обременения | Код по справочнику «Виды Обременения (ограничения)» | Строка длиной от 1 до 12 символов
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $encCode;
    /**
     * The encText
     * Meta informations extracted from the WSDL
     * - documentation: Текст обременения | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $encText;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер государствеенной регистрации | Строка длиной от 1 до 45 символов
     * - maxLength: 45
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата государственной регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * The durationStart
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $durationStart;
    /**
     * The durationFin
     * Meta informations extracted from the WSDL
     * - documentation: Дата прекращения действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $durationFin;
    /**
     * The durationTerm
     * Meta informations extracted from the WSDL
     * - documentation: Продолжительность | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $durationTerm;
    /**
     * Constructor method for SvedNedvEncumbranceType
     * @uses SvedNedvEncumbranceType::setEncCode()
     * @uses SvedNedvEncumbranceType::setEncText()
     * @uses SvedNedvEncumbranceType::setRegNumber()
     * @uses SvedNedvEncumbranceType::setRegDate()
     * @uses SvedNedvEncumbranceType::setDurationStart()
     * @uses SvedNedvEncumbranceType::setDurationFin()
     * @uses SvedNedvEncumbranceType::setDurationTerm()
     * @param string $encCode
     * @param string $encText
     * @param string $regNumber
     * @param string $regDate
     * @param string $durationStart
     * @param string $durationFin
     * @param string $durationTerm
     */
    public function __construct($encCode = null, $encText = null, $regNumber = null, $regDate = null, $durationStart = null, $durationFin = null, $durationTerm = null)
    {
        $this
            ->setEncCode($encCode)
            ->setEncText($encText)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate)
            ->setDurationStart($durationStart)
            ->setDurationFin($durationFin)
            ->setDurationTerm($durationTerm);
    }
    /**
     * Get encCode value
     * @return string|null
     */
    public function getEncCode()
    {
        return $this->encCode;
    }
    /**
     * Set encCode value
     * @param string $encCode
     * @return \StructType\SvedNedvEncumbranceType
     */
    public function setEncCode($encCode = null)
    {
        $this->encCode = $encCode;
        return $this;
    }
    /**
     * Get encText value
     * @return string|null
     */
    public function getEncText()
    {
        return $this->encText;
    }
    /**
     * Set encText value
     * @param string $encText
     * @return \StructType\SvedNedvEncumbranceType
     */
    public function setEncText($encText = null)
    {
        $this->encText = $encText;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \StructType\SvedNedvEncumbranceType
     */
    public function setRegNumber($regNumber = null)
    {
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \StructType\SvedNedvEncumbranceType
     */
    public function setRegDate($regDate = null)
    {
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Get durationStart value
     * @return string|null
     */
    public function getDurationStart()
    {
        return $this->durationStart;
    }
    /**
     * Set durationStart value
     * @param string $durationStart
     * @return \StructType\SvedNedvEncumbranceType
     */
    public function setDurationStart($durationStart = null)
    {
        $this->durationStart = $durationStart;
        return $this;
    }
    /**
     * Get durationFin value
     * @return string|null
     */
    public function getDurationFin()
    {
        return $this->durationFin;
    }
    /**
     * Set durationFin value
     * @param string $durationFin
     * @return \StructType\SvedNedvEncumbranceType
     */
    public function setDurationFin($durationFin = null)
    {
        $this->durationFin = $durationFin;
        return $this;
    }
    /**
     * Get durationTerm value
     * @return string|null
     */
    public function getDurationTerm()
    {
        return $this->durationTerm;
    }
    /**
     * Set durationTerm value
     * @param string $durationTerm
     * @return \StructType\SvedNedvEncumbranceType
     */
    public function setDurationTerm($durationTerm = null)
    {
        $this->durationTerm = $durationTerm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SvedNedvEncumbranceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
