<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedDoxodDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений SvedDoxodDataType "Полученный доход"
 * @subpackage Structs
 */
class SvedDoxodDataType extends InformationType
{
    /**
     * The DataDox
     * Meta informations extracted from the WSDL
     * - documentation: Дата получения дохода | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DataDox;
    /**
     * The SumDox
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма выплат и иных вознаграждений, начисленных в пользу физического лица | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SumDox;
    /**
     * The SumOPS
     * Meta informations extracted from the WSDL
     * - documentation: Сумма по ОПС | Из них на которые начислены страховые взносы на ОПС за календарный год | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SumOPS;
    /**
     * The Ground
     * Meta informations extracted from the WSDL
     * - documentation: Основание получения дохода | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Ground;
    /**
     * The CodePFR
     * Meta informations extracted from the WSDL
     * - documentation: Код вида выплаты ПФР | Строка длиной от 1 до 15 символов
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $CodePFR;
    /**
     * Constructor method for SvedDoxodDataType
     * @uses SvedDoxodDataType::setDataDox()
     * @uses SvedDoxodDataType::setSumDox()
     * @uses SvedDoxodDataType::setSumOPS()
     * @uses SvedDoxodDataType::setGround()
     * @uses SvedDoxodDataType::setCodePFR()
     * @param string $dataDox
     * @param float $sumDox
     * @param float $sumOPS
     * @param string $ground
     * @param string $codePFR
     */
    public function __construct($dataDox = null, $sumDox = null, $sumOPS = null, $ground = null, $codePFR = null)
    {
        $this
            ->setDataDox($dataDox)
            ->setSumDox($sumDox)
            ->setSumOPS($sumOPS)
            ->setGround($ground)
            ->setCodePFR($codePFR);
    }
    /**
     * Get DataDox value
     * @return string|null
     */
    public function getDataDox()
    {
        return $this->DataDox;
    }
    /**
     * Set DataDox value
     * @param string $dataDox
     * @return \StructType\SvedDoxodDataType
     */
    public function setDataDox($dataDox = null)
    {
        $this->DataDox = $dataDox;
        return $this;
    }
    /**
     * Get SumDox value
     * @return float|null
     */
    public function getSumDox()
    {
        return $this->SumDox;
    }
    /**
     * Set SumDox value
     * @param float $sumDox
     * @return \StructType\SvedDoxodDataType
     */
    public function setSumDox($sumDox = null)
    {
        $this->SumDox = $sumDox;
        return $this;
    }
    /**
     * Get SumOPS value
     * @return float|null
     */
    public function getSumOPS()
    {
        return $this->SumOPS;
    }
    /**
     * Set SumOPS value
     * @param float $sumOPS
     * @return \StructType\SvedDoxodDataType
     */
    public function setSumOPS($sumOPS = null)
    {
        $this->SumOPS = $sumOPS;
        return $this;
    }
    /**
     * Get Ground value
     * @return string|null
     */
    public function getGround()
    {
        return $this->Ground;
    }
    /**
     * Set Ground value
     * @param string $ground
     * @return \StructType\SvedDoxodDataType
     */
    public function setGround($ground = null)
    {
        $this->Ground = $ground;
        return $this;
    }
    /**
     * Get CodePFR value
     * @return string|null
     */
    public function getCodePFR()
    {
        return $this->CodePFR;
    }
    /**
     * Set CodePFR value
     * @param string $codePFR
     * @return \StructType\SvedDoxodDataType
     */
    public function setCodePFR($codePFR = null)
    {
        $this->CodePFR = $codePFR;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SvedDoxodDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
