<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoleEntrepreneurDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об индивидуальном предпринимателе
 * @subpackage Structs
 */
class SoleEntrepreneurDatumType extends PersonDatumType
{
    /**
     * The documentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Строка длиной 9 символов
     * - length: 9
     * @var string
     */
    public $documentId;
    /**
     * The soleEntrepreneurId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИП в базе данных | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $soleEntrepreneurId;
    /**
     * The OKVED
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о видах экономической деятельности
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OkvedDetailType[]
     */
    public $OKVED;
    /**
     * The kindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $kindId;
    /**
     * The kindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $kindName;
    /**
     * The statusId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния индивидуального предпринимателя (КФХ) | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $statusId;
    /**
     * The statusName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование состояния индивидуального предпринимателя (КФХ) | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $statusName;
    /**
     * The statusDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия указанного статуса (состояния) | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $statusDate;
    /**
     * The citizenDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата внесения записи с сведениями о гражданстве в ЕГРИП | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $citizenDate;
    /**
     * The citizenKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида гражданства | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $citizenKindId;
    /**
     * The citizenKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида гражданства | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $citizenKindName;
    /**
     * The countryId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор страны гражданства | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $countryId;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Код страны гражданства по классификатору ОКСМ | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по
     * классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $countryCode;
    /**
     * The countryName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование страны гражданства | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $countryName;
    /**
     * Constructor method for SoleEntrepreneurDatumType
     * @uses SoleEntrepreneurDatumType::setDocumentId()
     * @uses SoleEntrepreneurDatumType::setSoleEntrepreneurId()
     * @uses SoleEntrepreneurDatumType::setOKVED()
     * @uses SoleEntrepreneurDatumType::setKindId()
     * @uses SoleEntrepreneurDatumType::setKindName()
     * @uses SoleEntrepreneurDatumType::setStatusId()
     * @uses SoleEntrepreneurDatumType::setStatusName()
     * @uses SoleEntrepreneurDatumType::setStatusDate()
     * @uses SoleEntrepreneurDatumType::setCitizenDate()
     * @uses SoleEntrepreneurDatumType::setCitizenKindId()
     * @uses SoleEntrepreneurDatumType::setCitizenKindName()
     * @uses SoleEntrepreneurDatumType::setCountryId()
     * @uses SoleEntrepreneurDatumType::setCountryCode()
     * @uses SoleEntrepreneurDatumType::setCountryName()
     * @param string $documentId
     * @param int $soleEntrepreneurId
     * @param \StructType\OkvedDetailType[] $oKVED
     * @param int $kindId
     * @param string $kindName
     * @param int $statusId
     * @param string $statusName
     * @param string $statusDate
     * @param string $citizenDate
     * @param int $citizenKindId
     * @param string $citizenKindName
     * @param int $countryId
     * @param string $countryCode
     * @param string $countryName
     */
    public function __construct($documentId = null, $soleEntrepreneurId = null, array $oKVED = array(), $kindId = null, $kindName = null, $statusId = null, $statusName = null, $statusDate = null, $citizenDate = null, $citizenKindId = null, $citizenKindName = null, $countryId = null, $countryCode = null, $countryName = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setSoleEntrepreneurId($soleEntrepreneurId)
            ->setOKVED($oKVED)
            ->setKindId($kindId)
            ->setKindName($kindName)
            ->setStatusId($statusId)
            ->setStatusName($statusName)
            ->setStatusDate($statusDate)
            ->setCitizenDate($citizenDate)
            ->setCitizenKindId($citizenKindId)
            ->setCitizenKindName($citizenKindName)
            ->setCountryId($countryId)
            ->setCountryCode($countryCode)
            ->setCountryName($countryName);
    }
    /**
     * Get documentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param string $documentId
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setDocumentId($documentId = null)
    {
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get soleEntrepreneurId value
     * @return int|null
     */
    public function getSoleEntrepreneurId()
    {
        return $this->soleEntrepreneurId;
    }
    /**
     * Set soleEntrepreneurId value
     * @param int $soleEntrepreneurId
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setSoleEntrepreneurId($soleEntrepreneurId = null)
    {
        $this->soleEntrepreneurId = $soleEntrepreneurId;
        return $this;
    }
    /**
     * Get OKVED value
     * @return \StructType\OkvedDetailType[]|null
     */
    public function getOKVED()
    {
        return $this->OKVED;
    }
    /**
     * Set OKVED value
     * @throws \InvalidArgumentException
     * @param \StructType\OkvedDetailType[] $oKVED
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setOKVED(array $oKVED = array())
    {
        $this->OKVED = $oKVED;
        return $this;
    }
    /**
     * Add item to OKVED value
     * @throws \InvalidArgumentException
     * @param \StructType\OkvedDetailType $item
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function addToOKVED(\StructType\OkvedDetailType $item)
    {
        $this->OKVED[] = $item;
        return $this;
    }
    /**
     * Get kindId value
     * @return int|null
     */
    public function getKindId()
    {
        return $this->kindId;
    }
    /**
     * Set kindId value
     * @param int $kindId
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setKindId($kindId = null)
    {
        $this->kindId = $kindId;
        return $this;
    }
    /**
     * Get kindName value
     * @return string|null
     */
    public function getKindName()
    {
        return $this->kindName;
    }
    /**
     * Set kindName value
     * @param string $kindName
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setKindName($kindName = null)
    {
        $this->kindName = $kindName;
        return $this;
    }
    /**
     * Get statusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->statusId;
    }
    /**
     * Set statusId value
     * @param int $statusId
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setStatusId($statusId = null)
    {
        $this->statusId = $statusId;
        return $this;
    }
    /**
     * Get statusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->statusName;
    }
    /**
     * Set statusName value
     * @param string $statusName
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setStatusName($statusName = null)
    {
        $this->statusName = $statusName;
        return $this;
    }
    /**
     * Get statusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->statusDate;
    }
    /**
     * Set statusDate value
     * @param string $statusDate
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setStatusDate($statusDate = null)
    {
        $this->statusDate = $statusDate;
        return $this;
    }
    /**
     * Get citizenDate value
     * @return string|null
     */
    public function getCitizenDate()
    {
        return $this->citizenDate;
    }
    /**
     * Set citizenDate value
     * @param string $citizenDate
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setCitizenDate($citizenDate = null)
    {
        $this->citizenDate = $citizenDate;
        return $this;
    }
    /**
     * Get citizenKindId value
     * @return int|null
     */
    public function getCitizenKindId()
    {
        return $this->citizenKindId;
    }
    /**
     * Set citizenKindId value
     * @param int $citizenKindId
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setCitizenKindId($citizenKindId = null)
    {
        $this->citizenKindId = $citizenKindId;
        return $this;
    }
    /**
     * Get citizenKindName value
     * @return string|null
     */
    public function getCitizenKindName()
    {
        return $this->citizenKindName;
    }
    /**
     * Set citizenKindName value
     * @param string $citizenKindName
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setCitizenKindName($citizenKindName = null)
    {
        $this->citizenKindName = $citizenKindName;
        return $this;
    }
    /**
     * Get countryId value
     * @return int|null
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setCountryId($countryId = null)
    {
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setCountryCode($countryCode = null)
    {
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get countryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->countryName;
    }
    /**
     * Set countryName value
     * @param string $countryName
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public function setCountryName($countryName = null)
    {
        $this->countryName = $countryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SoleEntrepreneurDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
