<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipEngineType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о двигателях судна
 * @subpackage Structs
 */
class ShipEngineType extends AbstractStructBase
{
    /**
     * The EngineType
     * Meta informations extracted from the WSDL
     * - documentation: Тип двигателя
     * @var string
     */
    public $EngineType;
    /**
     * The BrandModelName
     * Meta informations extracted from the WSDL
     * - documentation: Марка и модель двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BrandModelName;
    /**
     * The SeriesNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер/Серия двигателя | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $SeriesNumber;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, кВт. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, л. с. | Количество
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * Constructor method for ShipEngineType
     * @uses ShipEngineType::setEngineType()
     * @uses ShipEngineType::setBrandModelName()
     * @uses ShipEngineType::setSeriesNumber()
     * @uses ShipEngineType::setEnginePowerKWh()
     * @uses ShipEngineType::setEnginePowerHp()
     * @param string $engineType
     * @param string $brandModelName
     * @param string $seriesNumber
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     */
    public function __construct($engineType = null, $brandModelName = null, $seriesNumber = null, $enginePowerKWh = null, $enginePowerHp = null)
    {
        $this
            ->setEngineType($engineType)
            ->setBrandModelName($brandModelName)
            ->setSeriesNumber($seriesNumber)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp);
    }
    /**
     * Get EngineType value
     * @return string|null
     */
    public function getEngineType()
    {
        return $this->EngineType;
    }
    /**
     * Set EngineType value
     * @uses \EnumType\ShipEngineCodeType::valueIsValid()
     * @uses \EnumType\ShipEngineCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $engineType
     * @return \StructType\ShipEngineType
     */
    public function setEngineType($engineType = null)
    {
        $this->EngineType = $engineType;
        return $this;
    }
    /**
     * Get BrandModelName value
     * @return string|null
     */
    public function getBrandModelName()
    {
        return $this->BrandModelName;
    }
    /**
     * Set BrandModelName value
     * @param string $brandModelName
     * @return \StructType\ShipEngineType
     */
    public function setBrandModelName($brandModelName = null)
    {
        $this->BrandModelName = $brandModelName;
        return $this;
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ShipEngineType
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \StructType\ShipEngineType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \StructType\ShipEngineType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipEngineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
