<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Судно
 * @subpackage Structs
 */
class ShipDatumType extends InformationType
{
    /**
     * The CategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип судна (плавсредства)
     * @var string
     */
    public $CategoryCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование судна | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The RegNumber
     * Meta informations extracted from the WSDL
     * - documentation: Государственный (бортовой) регистрационный знак | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RegNumber;
    /**
     * The HIN
     * Meta informations extracted from the WSDL
     * - documentation: Серийный номер судна | CIN/HIN
     * - minOccurs: 0
     * - maxLength: 14
     * - minLength: 12
     * - pattern: ([0-9]{12})|([0-9]{14})
     * @var string
     */
    public $HIN;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Марка | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - documentation: Модель | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ModelName;
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - documentation: Цвет | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Color;
    /**
     * The MadeYear
     * Meta informations extracted from the WSDL
     * - documentation: Год выпуска | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $MadeYear;
    /**
     * The Shipyard
     * Meta informations extracted from the WSDL
     * - documentation: Место постройки | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Shipyard;
    /**
     * The HullMaterial
     * Meta informations extracted from the WSDL
     * - documentation: Материал корпуса | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $HullMaterial;
    /**
     * The MaxOccupancy
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное количество людей на борту | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The Moorings
     * Meta informations extracted from the WSDL
     * - documentation: Место стоянки | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Moorings;
    /**
     * The EngineCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество двигателей | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $EngineCount;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, кВт | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, л. с. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * The Engines
     * Meta informations extracted from the WSDL
     * - documentation: Двигатели
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShipEngineType[]
     */
    public $Engines;
    /**
     * The ClassFormula
     * Meta informations extracted from the WSDL
     * - documentation: Формула класса | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ClassFormula;
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - documentation: Длина (м) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $Length;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - documentation: Высота (м) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $Width;
    /**
     * The SideHeight
     * Meta informations extracted from the WSDL
     * - documentation: Высота борта (м) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $SideHeight;
    /**
     * The SailSquare
     * Meta informations extracted from the WSDL
     * - documentation: Площадь паруса (м2) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $SailSquare;
    /**
     * The OwnershipDocument
     * Meta informations extracted from the WSDL
     * - documentation: Документы о приобретении | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OwnershipDocument;
    /**
     * The OwnershipDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата приобретения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OwnershipDate;
    /**
     * The NavigationPermitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Судовой билет | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $NavigationPermitNumber;
    /**
     * The NavigationPermitDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи судового билета | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $NavigationPermitDate;
    /**
     * The MortgageCertNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер свидетельства о залоге | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $MortgageCertNumber;
    /**
     * The MortgageCertDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи свидетельства | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $MortgageCertDate;
    /**
     * The Hijacking
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об угоне
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HijackingType[]
     */
    public $Hijacking;
    /**
     * The ShareValue
     * Meta informations extracted from the WSDL
     * - documentation: Доля (значение)
     * - minOccurs: 0
     * @var \StructType\ShareType
     */
    public $ShareValue;
    /**
     * The ShareText
     * Meta informations extracted from the WSDL
     * - documentation: Доля (текст) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $ShareText;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * The RegisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegisterDate;
    /**
     * The UnregisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчуждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $UnregisterDate;
    /**
     * Constructor method for ShipDatumType
     * @uses ShipDatumType::setCategoryCode()
     * @uses ShipDatumType::setName()
     * @uses ShipDatumType::setRegNumber()
     * @uses ShipDatumType::setHIN()
     * @uses ShipDatumType::setBrandName()
     * @uses ShipDatumType::setModelName()
     * @uses ShipDatumType::setColor()
     * @uses ShipDatumType::setMadeYear()
     * @uses ShipDatumType::setShipyard()
     * @uses ShipDatumType::setHullMaterial()
     * @uses ShipDatumType::setMaxOccupancy()
     * @uses ShipDatumType::setMoorings()
     * @uses ShipDatumType::setEngineCount()
     * @uses ShipDatumType::setEnginePowerKWh()
     * @uses ShipDatumType::setEnginePowerHp()
     * @uses ShipDatumType::setEngines()
     * @uses ShipDatumType::setClassFormula()
     * @uses ShipDatumType::setLength()
     * @uses ShipDatumType::setWidth()
     * @uses ShipDatumType::setSideHeight()
     * @uses ShipDatumType::setSailSquare()
     * @uses ShipDatumType::setOwnershipDocument()
     * @uses ShipDatumType::setOwnershipDate()
     * @uses ShipDatumType::setNavigationPermitNumber()
     * @uses ShipDatumType::setNavigationPermitDate()
     * @uses ShipDatumType::setMortgageCertNumber()
     * @uses ShipDatumType::setMortgageCertDate()
     * @uses ShipDatumType::setHijacking()
     * @uses ShipDatumType::setShareValue()
     * @uses ShipDatumType::setShareText()
     * @uses ShipDatumType::setDeptCode()
     * @uses ShipDatumType::setRegisterDate()
     * @uses ShipDatumType::setUnregisterDate()
     * @param string $categoryCode
     * @param string $name
     * @param string $regNumber
     * @param string $hIN
     * @param string $brandName
     * @param string $modelName
     * @param string $color
     * @param string $madeYear
     * @param string $shipyard
     * @param string $hullMaterial
     * @param int $maxOccupancy
     * @param string $moorings
     * @param int $engineCount
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     * @param \StructType\ShipEngineType[] $engines
     * @param string $classFormula
     * @param float $length
     * @param float $width
     * @param float $sideHeight
     * @param float $sailSquare
     * @param string $ownershipDocument
     * @param string $ownershipDate
     * @param string $navigationPermitNumber
     * @param string $navigationPermitDate
     * @param string $mortgageCertNumber
     * @param string $mortgageCertDate
     * @param \StructType\HijackingType[] $hijacking
     * @param \StructType\ShareType $shareValue
     * @param string $shareText
     * @param string $deptCode
     * @param string $registerDate
     * @param string $unregisterDate
     */
    public function __construct($categoryCode = null, $name = null, $regNumber = null, $hIN = null, $brandName = null, $modelName = null, $color = null, $madeYear = null, $shipyard = null, $hullMaterial = null, $maxOccupancy = null, $moorings = null, $engineCount = null, $enginePowerKWh = null, $enginePowerHp = null, array $engines = array(), $classFormula = null, $length = null, $width = null, $sideHeight = null, $sailSquare = null, $ownershipDocument = null, $ownershipDate = null, $navigationPermitNumber = null, $navigationPermitDate = null, $mortgageCertNumber = null, $mortgageCertDate = null, array $hijacking = array(), \StructType\ShareType $shareValue = null, $shareText = null, $deptCode = null, $registerDate = null, $unregisterDate = null)
    {
        $this
            ->setCategoryCode($categoryCode)
            ->setName($name)
            ->setRegNumber($regNumber)
            ->setHIN($hIN)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setColor($color)
            ->setMadeYear($madeYear)
            ->setShipyard($shipyard)
            ->setHullMaterial($hullMaterial)
            ->setMaxOccupancy($maxOccupancy)
            ->setMoorings($moorings)
            ->setEngineCount($engineCount)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp)
            ->setEngines($engines)
            ->setClassFormula($classFormula)
            ->setLength($length)
            ->setWidth($width)
            ->setSideHeight($sideHeight)
            ->setSailSquare($sailSquare)
            ->setOwnershipDocument($ownershipDocument)
            ->setOwnershipDate($ownershipDate)
            ->setNavigationPermitNumber($navigationPermitNumber)
            ->setNavigationPermitDate($navigationPermitDate)
            ->setMortgageCertNumber($mortgageCertNumber)
            ->setMortgageCertDate($mortgageCertDate)
            ->setHijacking($hijacking)
            ->setShareValue($shareValue)
            ->setShareText($shareText)
            ->setDeptCode($deptCode)
            ->setRegisterDate($registerDate)
            ->setUnregisterDate($unregisterDate);
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @uses \EnumType\ShipCategoryType::valueIsValid()
     * @uses \EnumType\ShipCategoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryCode
     * @return \StructType\ShipDatumType
     */
    public function setCategoryCode($categoryCode = null)
    {
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ShipDatumType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RegNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->RegNumber;
    }
    /**
     * Set RegNumber value
     * @param string $regNumber
     * @return \StructType\ShipDatumType
     */
    public function setRegNumber($regNumber = null)
    {
        $this->RegNumber = $regNumber;
        return $this;
    }
    /**
     * Get HIN value
     * @return string|null
     */
    public function getHIN()
    {
        return $this->HIN;
    }
    /**
     * Set HIN value
     * @param string $hIN
     * @return \StructType\ShipDatumType
     */
    public function setHIN($hIN = null)
    {
        $this->HIN = $hIN;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\ShipDatumType
     */
    public function setBrandName($brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \StructType\ShipDatumType
     */
    public function setModelName($modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\ShipDatumType
     */
    public function setColor($color = null)
    {
        $this->Color = $color;
        return $this;
    }
    /**
     * Get MadeYear value
     * @return string|null
     */
    public function getMadeYear()
    {
        return $this->MadeYear;
    }
    /**
     * Set MadeYear value
     * @param string $madeYear
     * @return \StructType\ShipDatumType
     */
    public function setMadeYear($madeYear = null)
    {
        $this->MadeYear = $madeYear;
        return $this;
    }
    /**
     * Get Shipyard value
     * @return string|null
     */
    public function getShipyard()
    {
        return $this->Shipyard;
    }
    /**
     * Set Shipyard value
     * @param string $shipyard
     * @return \StructType\ShipDatumType
     */
    public function setShipyard($shipyard = null)
    {
        $this->Shipyard = $shipyard;
        return $this;
    }
    /**
     * Get HullMaterial value
     * @return string|null
     */
    public function getHullMaterial()
    {
        return $this->HullMaterial;
    }
    /**
     * Set HullMaterial value
     * @param string $hullMaterial
     * @return \StructType\ShipDatumType
     */
    public function setHullMaterial($hullMaterial = null)
    {
        $this->HullMaterial = $hullMaterial;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\ShipDatumType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get Moorings value
     * @return string|null
     */
    public function getMoorings()
    {
        return $this->Moorings;
    }
    /**
     * Set Moorings value
     * @param string $moorings
     * @return \StructType\ShipDatumType
     */
    public function setMoorings($moorings = null)
    {
        $this->Moorings = $moorings;
        return $this;
    }
    /**
     * Get EngineCount value
     * @return int|null
     */
    public function getEngineCount()
    {
        return $this->EngineCount;
    }
    /**
     * Set EngineCount value
     * @param int $engineCount
     * @return \StructType\ShipDatumType
     */
    public function setEngineCount($engineCount = null)
    {
        $this->EngineCount = $engineCount;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \StructType\ShipDatumType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \StructType\ShipDatumType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Get Engines value
     * @return \StructType\ShipEngineType[]|null
     */
    public function getEngines()
    {
        return $this->Engines;
    }
    /**
     * Set Engines value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipEngineType[] $engines
     * @return \StructType\ShipDatumType
     */
    public function setEngines(array $engines = array())
    {
        $this->Engines = $engines;
        return $this;
    }
    /**
     * Add item to Engines value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipEngineType $item
     * @return \StructType\ShipDatumType
     */
    public function addToEngines(\StructType\ShipEngineType $item)
    {
        $this->Engines[] = $item;
        return $this;
    }
    /**
     * Get ClassFormula value
     * @return string|null
     */
    public function getClassFormula()
    {
        return $this->ClassFormula;
    }
    /**
     * Set ClassFormula value
     * @param string $classFormula
     * @return \StructType\ShipDatumType
     */
    public function setClassFormula($classFormula = null)
    {
        $this->ClassFormula = $classFormula;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\ShipDatumType
     */
    public function setLength($length = null)
    {
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\ShipDatumType
     */
    public function setWidth($width = null)
    {
        $this->Width = $width;
        return $this;
    }
    /**
     * Get SideHeight value
     * @return float|null
     */
    public function getSideHeight()
    {
        return $this->SideHeight;
    }
    /**
     * Set SideHeight value
     * @param float $sideHeight
     * @return \StructType\ShipDatumType
     */
    public function setSideHeight($sideHeight = null)
    {
        $this->SideHeight = $sideHeight;
        return $this;
    }
    /**
     * Get SailSquare value
     * @return float|null
     */
    public function getSailSquare()
    {
        return $this->SailSquare;
    }
    /**
     * Set SailSquare value
     * @param float $sailSquare
     * @return \StructType\ShipDatumType
     */
    public function setSailSquare($sailSquare = null)
    {
        $this->SailSquare = $sailSquare;
        return $this;
    }
    /**
     * Get OwnershipDocument value
     * @return string|null
     */
    public function getOwnershipDocument()
    {
        return $this->OwnershipDocument;
    }
    /**
     * Set OwnershipDocument value
     * @param string $ownershipDocument
     * @return \StructType\ShipDatumType
     */
    public function setOwnershipDocument($ownershipDocument = null)
    {
        $this->OwnershipDocument = $ownershipDocument;
        return $this;
    }
    /**
     * Get OwnershipDate value
     * @return string|null
     */
    public function getOwnershipDate()
    {
        return $this->OwnershipDate;
    }
    /**
     * Set OwnershipDate value
     * @param string $ownershipDate
     * @return \StructType\ShipDatumType
     */
    public function setOwnershipDate($ownershipDate = null)
    {
        $this->OwnershipDate = $ownershipDate;
        return $this;
    }
    /**
     * Get NavigationPermitNumber value
     * @return string|null
     */
    public function getNavigationPermitNumber()
    {
        return $this->NavigationPermitNumber;
    }
    /**
     * Set NavigationPermitNumber value
     * @param string $navigationPermitNumber
     * @return \StructType\ShipDatumType
     */
    public function setNavigationPermitNumber($navigationPermitNumber = null)
    {
        $this->NavigationPermitNumber = $navigationPermitNumber;
        return $this;
    }
    /**
     * Get NavigationPermitDate value
     * @return string|null
     */
    public function getNavigationPermitDate()
    {
        return $this->NavigationPermitDate;
    }
    /**
     * Set NavigationPermitDate value
     * @param string $navigationPermitDate
     * @return \StructType\ShipDatumType
     */
    public function setNavigationPermitDate($navigationPermitDate = null)
    {
        $this->NavigationPermitDate = $navigationPermitDate;
        return $this;
    }
    /**
     * Get MortgageCertNumber value
     * @return string|null
     */
    public function getMortgageCertNumber()
    {
        return $this->MortgageCertNumber;
    }
    /**
     * Set MortgageCertNumber value
     * @param string $mortgageCertNumber
     * @return \StructType\ShipDatumType
     */
    public function setMortgageCertNumber($mortgageCertNumber = null)
    {
        $this->MortgageCertNumber = $mortgageCertNumber;
        return $this;
    }
    /**
     * Get MortgageCertDate value
     * @return string|null
     */
    public function getMortgageCertDate()
    {
        return $this->MortgageCertDate;
    }
    /**
     * Set MortgageCertDate value
     * @param string $mortgageCertDate
     * @return \StructType\ShipDatumType
     */
    public function setMortgageCertDate($mortgageCertDate = null)
    {
        $this->MortgageCertDate = $mortgageCertDate;
        return $this;
    }
    /**
     * Get Hijacking value
     * @return \StructType\HijackingType[]|null
     */
    public function getHijacking()
    {
        return $this->Hijacking;
    }
    /**
     * Set Hijacking value
     * @throws \InvalidArgumentException
     * @param \StructType\HijackingType[] $hijacking
     * @return \StructType\ShipDatumType
     */
    public function setHijacking(array $hijacking = array())
    {
        $this->Hijacking = $hijacking;
        return $this;
    }
    /**
     * Add item to Hijacking value
     * @throws \InvalidArgumentException
     * @param \StructType\HijackingType $item
     * @return \StructType\ShipDatumType
     */
    public function addToHijacking(\StructType\HijackingType $item)
    {
        $this->Hijacking[] = $item;
        return $this;
    }
    /**
     * Get ShareValue value
     * @return \StructType\ShareType|null
     */
    public function getShareValue()
    {
        return $this->ShareValue;
    }
    /**
     * Set ShareValue value
     * @param \StructType\ShareType $shareValue
     * @return \StructType\ShipDatumType
     */
    public function setShareValue(\StructType\ShareType $shareValue = null)
    {
        $this->ShareValue = $shareValue;
        return $this;
    }
    /**
     * Get ShareText value
     * @return string|null
     */
    public function getShareText()
    {
        return $this->ShareText;
    }
    /**
     * Set ShareText value
     * @param string $shareText
     * @return \StructType\ShipDatumType
     */
    public function setShareText($shareText = null)
    {
        $this->ShareText = $shareText;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \StructType\ShipDatumType
     */
    public function setDeptCode($deptCode = null)
    {
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Get RegisterDate value
     * @return string|null
     */
    public function getRegisterDate()
    {
        return $this->RegisterDate;
    }
    /**
     * Set RegisterDate value
     * @param string $registerDate
     * @return \StructType\ShipDatumType
     */
    public function setRegisterDate($registerDate = null)
    {
        $this->RegisterDate = $registerDate;
        return $this;
    }
    /**
     * Get UnregisterDate value
     * @return string|null
     */
    public function getUnregisterDate()
    {
        return $this->UnregisterDate;
    }
    /**
     * Set UnregisterDate value
     * @param string $unregisterDate
     * @return \StructType\ShipDatumType
     */
    public function setUnregisterDate($unregisterDate = null)
    {
        $this->UnregisterDate = $unregisterDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
