<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SequestrationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер Sequestration «Сведения об аресте имущества и имеющихся ограничениях» | Используется для передачи сведений об аресте
 * имущества и имеющихся ограничениях (постановлении о наложении ареста на имущество должника). Для ФНС России при вынесении
 * постановления по статье 77 НК РФ: Обязателен.
 * @subpackage Structs
 */
class SequestrationType extends AbstractStructBase
{
    /**
     * The ReportProperty
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об имуществе
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ReportPropertyType[]
     */
    public $ReportProperty;
    /**
     * The OrderNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $OrderNumber;
    /**
     * The OrderDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OrderDate;
    /**
     * The OrderSanctionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вступления постановления в силу после получении санкции прокурора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OrderSanctionDate;
    /**
     * Constructor method for SequestrationType
     * @uses SequestrationType::setReportProperty()
     * @uses SequestrationType::setOrderNumber()
     * @uses SequestrationType::setOrderDate()
     * @uses SequestrationType::setOrderSanctionDate()
     * @param \StructType\ReportPropertyType[] $reportProperty
     * @param string $orderNumber
     * @param string $orderDate
     * @param string $orderSanctionDate
     */
    public function __construct(array $reportProperty = array(), $orderNumber = null, $orderDate = null, $orderSanctionDate = null)
    {
        $this
            ->setReportProperty($reportProperty)
            ->setOrderNumber($orderNumber)
            ->setOrderDate($orderDate)
            ->setOrderSanctionDate($orderSanctionDate);
    }
    /**
     * Get ReportProperty value
     * @return \StructType\ReportPropertyType[]
     */
    public function getReportProperty()
    {
        return $this->ReportProperty;
    }
    /**
     * Set ReportProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\ReportPropertyType[] $reportProperty
     * @return \StructType\SequestrationType
     */
    public function setReportProperty(array $reportProperty = array())
    {
        $this->ReportProperty = $reportProperty;
        return $this;
    }
    /**
     * Add item to ReportProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\ReportPropertyType $item
     * @return \StructType\SequestrationType
     */
    public function addToReportProperty(\StructType\ReportPropertyType $item)
    {
        $this->ReportProperty[] = $item;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\SequestrationType
     */
    public function setOrderNumber($orderNumber = null)
    {
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \StructType\SequestrationType
     */
    public function setOrderDate($orderDate = null)
    {
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get OrderSanctionDate value
     * @return string|null
     */
    public function getOrderSanctionDate()
    {
        return $this->OrderSanctionDate;
    }
    /**
     * Set OrderSanctionDate value
     * @param string $orderSanctionDate
     * @return \StructType\SequestrationType
     */
    public function setOrderSanctionDate($orderSanctionDate = null)
    {
        $this->OrderSanctionDate = $orderSanctionDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SequestrationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
