<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalaryWithheldDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
 * @subpackage Structs
 */
class SalaryWithheldDatumType extends InformationType
{
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции
     * @var string
     */
    public $TransactionType;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата операции | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $TransactionDate;
    /**
     * The SalaryAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SalaryAmount;
    /**
     * The PayoutAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма полученная | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PayoutAmount;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Основание | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * The Withhelds
     * Meta informations extracted from the WSDL
     * - documentation: Удержано
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WithheldDetailType[]
     */
    public $Withhelds;
    /**
     * Constructor method for SalaryWithheldDatumType
     * @uses SalaryWithheldDatumType::setTransactionType()
     * @uses SalaryWithheldDatumType::setTransactionDate()
     * @uses SalaryWithheldDatumType::setSalaryAmount()
     * @uses SalaryWithheldDatumType::setPayoutAmount()
     * @uses SalaryWithheldDatumType::setGrounds()
     * @uses SalaryWithheldDatumType::setWithhelds()
     * @param string $transactionType
     * @param string $transactionDate
     * @param float $salaryAmount
     * @param float $payoutAmount
     * @param string $grounds
     * @param \StructType\WithheldDetailType[] $withhelds
     */
    public function __construct($transactionType = null, $transactionDate = null, $salaryAmount = null, $payoutAmount = null, $grounds = null, array $withhelds = array())
    {
        $this
            ->setTransactionType($transactionType)
            ->setTransactionDate($transactionDate)
            ->setSalaryAmount($salaryAmount)
            ->setPayoutAmount($payoutAmount)
            ->setGrounds($grounds)
            ->setWithhelds($withhelds);
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\AccountTransactionType::valueIsValid()
     * @uses \EnumType\AccountTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\SalaryWithheldDatumType
     */
    public function setTransactionType($transactionType = null)
    {
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\SalaryWithheldDatumType
     */
    public function setTransactionDate($transactionDate = null)
    {
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get SalaryAmount value
     * @return float|null
     */
    public function getSalaryAmount()
    {
        return $this->SalaryAmount;
    }
    /**
     * Set SalaryAmount value
     * @param float $salaryAmount
     * @return \StructType\SalaryWithheldDatumType
     */
    public function setSalaryAmount($salaryAmount = null)
    {
        $this->SalaryAmount = $salaryAmount;
        return $this;
    }
    /**
     * Get PayoutAmount value
     * @return float|null
     */
    public function getPayoutAmount()
    {
        return $this->PayoutAmount;
    }
    /**
     * Set PayoutAmount value
     * @param float $payoutAmount
     * @return \StructType\SalaryWithheldDatumType
     */
    public function setPayoutAmount($payoutAmount = null)
    {
        $this->PayoutAmount = $payoutAmount;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \StructType\SalaryWithheldDatumType
     */
    public function setGrounds($grounds = null)
    {
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Get Withhelds value
     * @return \StructType\WithheldDetailType[]|null
     */
    public function getWithhelds()
    {
        return $this->Withhelds;
    }
    /**
     * Set Withhelds value
     * @throws \InvalidArgumentException
     * @param \StructType\WithheldDetailType[] $withhelds
     * @return \StructType\SalaryWithheldDatumType
     */
    public function setWithhelds(array $withhelds = array())
    {
        $this->Withhelds = $withhelds;
        return $this;
    }
    /**
     * Add item to Withhelds value
     * @throws \InvalidArgumentException
     * @param \StructType\WithheldDetailType $item
     * @return \StructType\SalaryWithheldDatumType
     */
    public function addToWithhelds(\StructType\WithheldDetailType $item)
    {
        $this->Withhelds[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalaryWithheldDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
