<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restrictn StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ Restrictn "Постановление к исполнению" | Постановление СПИ о наложении ограничения (ареста)/о снятии ограничения (ареста) |
 * ЭП
 * - type: tns:Restrictn
 * @subpackage Structs
 */
class Restrictn extends AbstractStructBase
{
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: ИП | Содержит основные сведения об исполнительном производстве и должнике
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IP
     */
    public $IP;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор постановления, присвоенный АИС ФССП России | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата постановления о наложении ограничения (ареста)/о снятии ограничения (ареста) | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, вынесшего постановление | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ/должностного лица ФССП России, утвердившего документ | Полное имя физического лица (фамилия, имя,
     * отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ/должностного лица ФССП России, утвердившего документ | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер постановления о наложении ограничения (ареста)/о снятии ограничения (ареста) | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих-код | Штрих-код документа в формате code 39. Значение этого поля имеет формат: «NNNNNNNNN/DDDD-Y...Y», где NNNNNNNNN — числовой
     * идентификатор документа, DDDD — код отдела СП по справочнику ВКСП, Y...Y – номер копии. | Штрих-код в формате code39
     * - minOccurs: 0
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма средств, на которую накладывается/снимается ограничение. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия ограничения | Если дата начала действия ограничения не указана, ограничение действует с момента
     * получения документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $StartDate;
    /**
     * The FinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия ограничения | Если дата окончания действия ограничения не указана, ограничение действует до явного
     * снятия ограничения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $FinDate;
    /**
     * The AppOrder
     * Meta informations extracted from the WSDL
     * - documentation: Порядок обжалования | Порядок обжалования постановления, значение по умолчанию - «постановление судебного
     * пристава-исполнителя может быть обжаловано в порядке подчиненности вышестоящему должностному лицу службы судебных приставов или
     * оспорено в суде в 10-дневный срок» | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AppOrder;
    /**
     * The DocCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocCode;
    /**
     * The RestrDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления об ограничении | Поле заполняются только для постановления о снятии ограничения | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $RestrDocId;
    /**
     * The RestrDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления об ограничении | Поле заполняются только для постановления о снятии ограничения | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RestrDocNumber;
    /**
     * The RestrDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления об ограничении | Поле заполняются только для постановления о снятии ограничения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RestrDocDate;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Основание решения СПИ | Текст основания принятия решения | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Reason;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - documentation: Статья | Статья основания принятия решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Article;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Point;
    /**
     * The Part
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт | Подпункт статьи основания решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Part;
    /**
     * The ArrestRemovalMode
     * Meta informations extracted from the WSDL
     * - documentation: Режим снятия ареста | Может содержаться только в постановлениях о снятии ареста
     * - minOccurs: 0
     * @var string
     */
    public $ArrestRemovalMode;
    /**
     * The ResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Оригинал постановления СПИ, вынесенного в соответствии с Приказом ФССП России от 22.04.2015 № 248 «Об
     * утверждении требований к формату постановления судебного пристава-исполнителя или иного должностного лица Федеральной службы
     * судебных приставов, вынесенного в форме электронного документа» в форме электронного документа в формате в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $ResolutionBase;
    /**
     * The SignatureResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП постановления СПИ | ЭП постановления СПИ вынесенного в электронном виде, элемента «ResolutionBase» в формате pkcs#7
     * - minOccurs: 0
     * @var string
     */
    public $SignatureResolutionBase;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения о должнике
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The OspProperty
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты ОСП
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OspProperty
     */
    public $OspProperty;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Restrictn
     * @uses Restrictn::setIP()
     * @uses Restrictn::setInternalKey()
     * @uses Restrictn::setDocDate()
     * @uses Restrictn::setSPI()
     * @uses Restrictn::setSPIFio()
     * @uses Restrictn::setSPITel()
     * @uses Restrictn::setSPIPost()
     * @uses Restrictn::setDocNum()
     * @uses Restrictn::setBarcode()
     * @uses Restrictn::setAmount()
     * @uses Restrictn::setStartDate()
     * @uses Restrictn::setFinDate()
     * @uses Restrictn::setAppOrder()
     * @uses Restrictn::setDocCode()
     * @uses Restrictn::setRestrDocId()
     * @uses Restrictn::setRestrDocNumber()
     * @uses Restrictn::setRestrDocDate()
     * @uses Restrictn::setReason()
     * @uses Restrictn::setArticle()
     * @uses Restrictn::setPoint()
     * @uses Restrictn::setPart()
     * @uses Restrictn::setArrestRemovalMode()
     * @uses Restrictn::setResolutionBase()
     * @uses Restrictn::setSignatureResolutionBase()
     * @uses Restrictn::setData()
     * @uses Restrictn::setOspProperty()
     * @uses Restrictn::setSignDateTime()
     * @uses Restrictn::setSignature()
     * @uses Restrictn::setId()
     * @param \StructType\IP $iP
     * @param int $internalKey
     * @param string $docDate
     * @param int $sPI
     * @param string $sPIFio
     * @param string $sPITel
     * @param string $sPIPost
     * @param string $docNum
     * @param string $barcode
     * @param float $amount
     * @param string $startDate
     * @param string $finDate
     * @param string $appOrder
     * @param string $docCode
     * @param int $restrDocId
     * @param string $restrDocNumber
     * @param string $restrDocDate
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $part
     * @param string $arrestRemovalMode
     * @param string $resolutionBase
     * @param string $signatureResolutionBase
     * @param \StructType\Data[] $data
     * @param \StructType\OspProperty $ospProperty
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct(\StructType\IP $iP = null, $internalKey = null, $docDate = null, $sPI = null, $sPIFio = null, $sPITel = null, $sPIPost = null, $docNum = null, $barcode = null, $amount = null, $startDate = null, $finDate = null, $appOrder = null, $docCode = null, $restrDocId = null, $restrDocNumber = null, $restrDocDate = null, $reason = null, $article = null, $point = null, $part = null, $arrestRemovalMode = null, $resolutionBase = null, $signatureResolutionBase = null, array $data = array(), \StructType\OspProperty $ospProperty = null, $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setIP($iP)
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setDocNum($docNum)
            ->setBarcode($barcode)
            ->setAmount($amount)
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setAppOrder($appOrder)
            ->setDocCode($docCode)
            ->setRestrDocId($restrDocId)
            ->setRestrDocNumber($restrDocNumber)
            ->setRestrDocDate($restrDocDate)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setPart($part)
            ->setArrestRemovalMode($arrestRemovalMode)
            ->setResolutionBase($resolutionBase)
            ->setSignatureResolutionBase($signatureResolutionBase)
            ->setData($data)
            ->setOspProperty($ospProperty)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get IP value
     * @return \StructType\IP
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \StructType\IP $iP
     * @return \StructType\Restrictn
     */
    public function setIP(\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\Restrictn
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\Restrictn
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \StructType\Restrictn
     */
    public function setSPI($sPI = null)
    {
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\Restrictn
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \StructType\Restrictn
     */
    public function setSPITel($sPITel = null)
    {
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\Restrictn
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \StructType\Restrictn
     */
    public function setDocNum($docNum = null)
    {
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\Restrictn
     */
    public function setBarcode($barcode = null)
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Restrictn
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Restrictn
     */
    public function setStartDate($startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get FinDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->FinDate;
    }
    /**
     * Set FinDate value
     * @param string $finDate
     * @return \StructType\Restrictn
     */
    public function setFinDate($finDate = null)
    {
        $this->FinDate = $finDate;
        return $this;
    }
    /**
     * Get AppOrder value
     * @return string|null
     */
    public function getAppOrder()
    {
        return $this->AppOrder;
    }
    /**
     * Set AppOrder value
     * @param string $appOrder
     * @return \StructType\Restrictn
     */
    public function setAppOrder($appOrder = null)
    {
        $this->AppOrder = $appOrder;
        return $this;
    }
    /**
     * Get DocCode value
     * @return string|null
     */
    public function getDocCode()
    {
        return $this->DocCode;
    }
    /**
     * Set DocCode value
     * @param string $docCode
     * @return \StructType\Restrictn
     */
    public function setDocCode($docCode = null)
    {
        $this->DocCode = $docCode;
        return $this;
    }
    /**
     * Get RestrDocId value
     * @return int|null
     */
    public function getRestrDocId()
    {
        return $this->RestrDocId;
    }
    /**
     * Set RestrDocId value
     * @param int $restrDocId
     * @return \StructType\Restrictn
     */
    public function setRestrDocId($restrDocId = null)
    {
        $this->RestrDocId = $restrDocId;
        return $this;
    }
    /**
     * Get RestrDocNumber value
     * @return string|null
     */
    public function getRestrDocNumber()
    {
        return $this->RestrDocNumber;
    }
    /**
     * Set RestrDocNumber value
     * @param string $restrDocNumber
     * @return \StructType\Restrictn
     */
    public function setRestrDocNumber($restrDocNumber = null)
    {
        $this->RestrDocNumber = $restrDocNumber;
        return $this;
    }
    /**
     * Get RestrDocDate value
     * @return string|null
     */
    public function getRestrDocDate()
    {
        return $this->RestrDocDate;
    }
    /**
     * Set RestrDocDate value
     * @param string $restrDocDate
     * @return \StructType\Restrictn
     */
    public function setRestrDocDate($restrDocDate = null)
    {
        $this->RestrDocDate = $restrDocDate;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\Restrictn
     */
    public function setReason($reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \StructType\Restrictn
     */
    public function setArticle($article = null)
    {
        $this->Article = $article;
        return $this;
    }
    /**
     * Get Point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @param string $point
     * @return \StructType\Restrictn
     */
    public function setPoint($point = null)
    {
        $this->Point = $point;
        return $this;
    }
    /**
     * Get Part value
     * @return string|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * Set Part value
     * @param string $part
     * @return \StructType\Restrictn
     */
    public function setPart($part = null)
    {
        $this->Part = $part;
        return $this;
    }
    /**
     * Get ArrestRemovalMode value
     * @return string|null
     */
    public function getArrestRemovalMode()
    {
        return $this->ArrestRemovalMode;
    }
    /**
     * Set ArrestRemovalMode value
     * @uses \EnumType\ArrestRemovalModeType::valueIsValid()
     * @uses \EnumType\ArrestRemovalModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrestRemovalMode
     * @return \StructType\Restrictn
     */
    public function setArrestRemovalMode($arrestRemovalMode = null)
    {
        $this->ArrestRemovalMode = $arrestRemovalMode;
        return $this;
    }
    /**
     * Get ResolutionBase value
     * @return string|null
     */
    public function getResolutionBase()
    {
        return $this->ResolutionBase;
    }
    /**
     * Set ResolutionBase value
     * @param string $resolutionBase
     * @return \StructType\Restrictn
     */
    public function setResolutionBase($resolutionBase = null)
    {
        $this->ResolutionBase = $resolutionBase;
        return $this;
    }
    /**
     * Get SignatureResolutionBase value
     * @return string|null
     */
    public function getSignatureResolutionBase()
    {
        return $this->SignatureResolutionBase;
    }
    /**
     * Set SignatureResolutionBase value
     * @param string $signatureResolutionBase
     * @return \StructType\Restrictn
     */
    public function setSignatureResolutionBase($signatureResolutionBase = null)
    {
        $this->SignatureResolutionBase = $signatureResolutionBase;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\Restrictn
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Restrictn
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get OspProperty value
     * @return \StructType\OspProperty|null
     */
    public function getOspProperty()
    {
        return $this->OspProperty;
    }
    /**
     * Set OspProperty value
     * @param \StructType\OspProperty $ospProperty
     * @return \StructType\Restrictn
     */
    public function setOspProperty(\StructType\OspProperty $ospProperty = null)
    {
        $this->OspProperty = $ospProperty;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\Restrictn
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\Restrictn
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\Restrictn
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Restrictn
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Restrictn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
