<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реестр ограничений
 * - type: tns:RestrictionRegistry
 * @subpackage Structs
 */
class RestrictionRegistry extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Строка длиной от 1 до 8 символов
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Version;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The UnloadVersion
     * Meta informations extracted from the WSDL
     * - documentation: Версия реестра текущая | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $UnloadVersion;
    /**
     * The PrevVersion
     * Meta informations extracted from the WSDL
     * - documentation: Версия реестра предыдущего | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $PrevVersion;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер реестра ограничения | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак обновления | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PrevDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата предыдущей выгрузки | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PrevDate;
    /**
     * The RecordCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество записей реестра ограничений | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $RecordCount;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RestrictionRegistry
     * @uses RestrictionRegistry::setVersion()
     * @uses RestrictionRegistry::setInternalKey()
     * @uses RestrictionRegistry::setUnloadVersion()
     * @uses RestrictionRegistry::setPrevVersion()
     * @uses RestrictionRegistry::setOspCode()
     * @uses RestrictionRegistry::setDocNumber()
     * @uses RestrictionRegistry::setIsUpdate()
     * @uses RestrictionRegistry::setUnloadDate()
     * @uses RestrictionRegistry::setPrevDate()
     * @uses RestrictionRegistry::setRecordCount()
     * @uses RestrictionRegistry::setId()
     * @param string $version
     * @param int $internalKey
     * @param int $unloadVersion
     * @param int $prevVersion
     * @param string $ospCode
     * @param string $docNumber
     * @param bool $isUpdate
     * @param string $unloadDate
     * @param string $prevDate
     * @param int $recordCount
     * @param string $id
     */
    public function __construct($version = null, $internalKey = null, $unloadVersion = null, $prevVersion = null, $ospCode = null, $docNumber = null, $isUpdate = null, $unloadDate = null, $prevDate = null, $recordCount = null, $id = null)
    {
        $this
            ->setVersion($version)
            ->setInternalKey($internalKey)
            ->setUnloadVersion($unloadVersion)
            ->setPrevVersion($prevVersion)
            ->setOspCode($ospCode)
            ->setDocNumber($docNumber)
            ->setIsUpdate($isUpdate)
            ->setUnloadDate($unloadDate)
            ->setPrevDate($prevDate)
            ->setRecordCount($recordCount)
            ->setId($id);
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\RestrictionRegistry
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\RestrictionRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get UnloadVersion value
     * @return int|null
     */
    public function getUnloadVersion()
    {
        return $this->UnloadVersion;
    }
    /**
     * Set UnloadVersion value
     * @param int $unloadVersion
     * @return \StructType\RestrictionRegistry
     */
    public function setUnloadVersion($unloadVersion = null)
    {
        $this->UnloadVersion = $unloadVersion;
        return $this;
    }
    /**
     * Get PrevVersion value
     * @return int|null
     */
    public function getPrevVersion()
    {
        return $this->PrevVersion;
    }
    /**
     * Set PrevVersion value
     * @param int $prevVersion
     * @return \StructType\RestrictionRegistry
     */
    public function setPrevVersion($prevVersion = null)
    {
        $this->PrevVersion = $prevVersion;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\RestrictionRegistry
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\RestrictionRegistry
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \StructType\RestrictionRegistry
     */
    public function setIsUpdate($isUpdate = null)
    {
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\RestrictionRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PrevDate value
     * @return string|null
     */
    public function getPrevDate()
    {
        return $this->PrevDate;
    }
    /**
     * Set PrevDate value
     * @param string $prevDate
     * @return \StructType\RestrictionRegistry
     */
    public function setPrevDate($prevDate = null)
    {
        $this->PrevDate = $prevDate;
        return $this;
    }
    /**
     * Get RecordCount value
     * @return int|null
     */
    public function getRecordCount()
    {
        return $this->RecordCount;
    }
    /**
     * Set RecordCount value
     * @param int $recordCount
     * @return \StructType\RestrictionRegistry
     */
    public function setRecordCount($recordCount = null)
    {
        $this->RecordCount = $recordCount;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RestrictionRegistry
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestrictionRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
