<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionActInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об арестах и ограничениях, наложенных судебными приставами-исполнителями на имущество должников | ЭП
 * - type: tns:RestrictionActInfo
 * @subpackage Structs
 */
class RestrictionActInfo extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор документа, присвоенный АИС ФССП России. | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор документа запроса АИС внешнего контрагента. | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestKey;
    /**
     * The HasActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия постановлений | Признак наличия постановления об ограничении выезда. | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $HasActInfo;
    /**
     * The ActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Постановление об аресте и ограничении | Сведения об арестах и ограничениях, наложенных судебными приставами-исполнителями на
     * имущество должников.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActInfoType[]
     */
    public $ActInfo;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RestrictionActInfo
     * @uses RestrictionActInfo::setInternalKey()
     * @uses RestrictionActInfo::setRequestKey()
     * @uses RestrictionActInfo::setHasActInfo()
     * @uses RestrictionActInfo::setActInfo()
     * @uses RestrictionActInfo::setSignDateTime()
     * @uses RestrictionActInfo::setSignature()
     * @uses RestrictionActInfo::setId()
     * @param int $internalKey
     * @param string $requestKey
     * @param bool $hasActInfo
     * @param \StructType\ActInfoType[] $actInfo
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestKey = null, $hasActInfo = null, array $actInfo = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestKey($requestKey)
            ->setHasActInfo($hasActInfo)
            ->setActInfo($actInfo)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\RestrictionActInfo
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->RequestKey;
    }
    /**
     * Set RequestKey value
     * @param string $requestKey
     * @return \StructType\RestrictionActInfo
     */
    public function setRequestKey($requestKey = null)
    {
        $this->RequestKey = $requestKey;
        return $this;
    }
    /**
     * Get HasActInfo value
     * @return bool|null
     */
    public function getHasActInfo()
    {
        return $this->HasActInfo;
    }
    /**
     * Set HasActInfo value
     * @param bool $hasActInfo
     * @return \StructType\RestrictionActInfo
     */
    public function setHasActInfo($hasActInfo = null)
    {
        $this->HasActInfo = $hasActInfo;
        return $this;
    }
    /**
     * Get ActInfo value
     * @return \StructType\ActInfoType[]|null
     */
    public function getActInfo()
    {
        return $this->ActInfo;
    }
    /**
     * Set ActInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ActInfoType[] $actInfo
     * @return \StructType\RestrictionActInfo
     */
    public function setActInfo(array $actInfo = array())
    {
        $this->ActInfo = $actInfo;
        return $this;
    }
    /**
     * Add item to ActInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ActInfoType $item
     * @return \StructType\RestrictionActInfo
     */
    public function addToActInfo(\StructType\ActInfoType $item)
    {
        $this->ActInfo[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\RestrictionActInfo
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\RestrictionActInfo
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\RestrictionActInfo
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RestrictionActInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestrictionActInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
