<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestByDatum StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос данных по имеющимся сведениям
 * @subpackage Structs
 */
abstract class RequestByDatum extends AbstractStructBase
{
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The authorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, от имени которого направляется запрос
     * @var \StructType\FioType
     */
    public $authorName;
    /**
     * The authorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Наименование должности | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $authorPost;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Таблица 18:Тип данных «Сведения» Data. Сведения о физическом лице. Обязательна передача сведений типа PersonDatumType (тип
     * сведений 18) «Сведения о физическом лице», сведений типа AddressDataType (тип сведений 16) «Адрес регистрации» и сведений типа IdentificationDataType (тип
     * сведений 01). Сведения юридическом лице. Обязательна передача сведений типах CompanyDatumType (тип сведений 19) «Сведения о юридическом лице»,
     * сведений типа AddressDataType (тип сведений 16) «Адрес регистрации».
     * - maxOccurs: unbounded
     * @var \StructType\Data[]
     */
    public $data;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RequestByDatum
     * @uses RequestByDatum::setExternalKey()
     * @uses RequestByDatum::setDocDate()
     * @uses RequestByDatum::setDocNumber()
     * @uses RequestByDatum::setAuthorName()
     * @uses RequestByDatum::setAuthorPost()
     * @uses RequestByDatum::setData()
     * @uses RequestByDatum::setId()
     * @param string $externalKey
     * @param string $docDate
     * @param string $docNumber
     * @param \StructType\FioType $authorName
     * @param string $authorPost
     * @param \StructType\Data[] $data
     * @param string $id
     */
    public function __construct($externalKey = null, $docDate = null, $docNumber = null, \StructType\FioType $authorName = null, $authorPost = null, array $data = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setData($data)
            ->setId($id);
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \StructType\RequestByDatum
     */
    public function setExternalKey($externalKey = null)
    {
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\RequestByDatum
     */
    public function setDocDate($docDate = null)
    {
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\RequestByDatum
     */
    public function setDocNumber($docNumber = null)
    {
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get authorName value
     * @return \StructType\FioType|null
     */
    public function getAuthorName()
    {
        return $this->authorName;
    }
    /**
     * Set authorName value
     * @param \StructType\FioType $authorName
     * @return \StructType\RequestByDatum
     */
    public function setAuthorName(\StructType\FioType $authorName = null)
    {
        $this->authorName = $authorName;
        return $this;
    }
    /**
     * Get authorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->authorPost;
    }
    /**
     * Set authorPost value
     * @param string $authorPost
     * @return \StructType\RequestByDatum
     */
    public function setAuthorPost($authorPost = null)
    {
        $this->authorPost = $authorPost;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\RequestByDatum
     */
    public function setData(array $data = array())
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Add item to data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\RequestByDatum
     */
    public function addToData(\StructType\Data $item)
    {
        $this->data[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RequestByDatum
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestByDatum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
