<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос (абстрактный)
 * @subpackage Structs
 */
abstract class Request extends AbstractStructBase
{
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * Constructor method for Request
     * @uses Request::setExternalKey()
     * @param string $externalKey
     */
    public function __construct($externalKey = null)
    {
        $this
            ->setExternalKey($externalKey);
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \StructType\Request
     */
    public function setExternalKey($externalKey = null)
    {
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
