<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportPropertyType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер ReportProperty «Сведения об имуществе» | Указывается сведения об имуществе.
 * @subpackage Structs
 */
class ReportPropertyType extends AbstractStructBase
{
    /**
     * The CourtOrdersNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер протокола об аресте имущества | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $CourtOrdersNumber;
    /**
     * The CourtOrdersDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата протокола об аресте имущества | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CourtOrdersDate;
    /**
     * The PropertyKind
     * Meta informations extracted from the WSDL
     * - documentation: Имущество
     * @var string
     */
    public $PropertyKind;
    /**
     * The CauseArrest
     * Meta informations extracted from the WSDL
     * - documentation: Основание ареста | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $CauseArrest;
    /**
     * The Ban
     * Meta informations extracted from the WSDL
     * - documentation: Вид ареста
     * @var string
     */
    public $Ban;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Общее описание | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Description;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма арестованного имущества | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * Constructor method for ReportPropertyType
     * @uses ReportPropertyType::setCourtOrdersNumber()
     * @uses ReportPropertyType::setCourtOrdersDate()
     * @uses ReportPropertyType::setPropertyKind()
     * @uses ReportPropertyType::setCauseArrest()
     * @uses ReportPropertyType::setBan()
     * @uses ReportPropertyType::setDescription()
     * @uses ReportPropertyType::setAmount()
     * @uses ReportPropertyType::setData()
     * @param string $courtOrdersNumber
     * @param string $courtOrdersDate
     * @param string $propertyKind
     * @param string $causeArrest
     * @param string $ban
     * @param string $description
     * @param float $amount
     * @param \StructType\Data[] $data
     */
    public function __construct($courtOrdersNumber = null, $courtOrdersDate = null, $propertyKind = null, $causeArrest = null, $ban = null, $description = null, $amount = null, array $data = array())
    {
        $this
            ->setCourtOrdersNumber($courtOrdersNumber)
            ->setCourtOrdersDate($courtOrdersDate)
            ->setPropertyKind($propertyKind)
            ->setCauseArrest($causeArrest)
            ->setBan($ban)
            ->setDescription($description)
            ->setAmount($amount)
            ->setData($data);
    }
    /**
     * Get CourtOrdersNumber value
     * @return string|null
     */
    public function getCourtOrdersNumber()
    {
        return $this->CourtOrdersNumber;
    }
    /**
     * Set CourtOrdersNumber value
     * @param string $courtOrdersNumber
     * @return \StructType\ReportPropertyType
     */
    public function setCourtOrdersNumber($courtOrdersNumber = null)
    {
        $this->CourtOrdersNumber = $courtOrdersNumber;
        return $this;
    }
    /**
     * Get CourtOrdersDate value
     * @return string|null
     */
    public function getCourtOrdersDate()
    {
        return $this->CourtOrdersDate;
    }
    /**
     * Set CourtOrdersDate value
     * @param string $courtOrdersDate
     * @return \StructType\ReportPropertyType
     */
    public function setCourtOrdersDate($courtOrdersDate = null)
    {
        $this->CourtOrdersDate = $courtOrdersDate;
        return $this;
    }
    /**
     * Get PropertyKind value
     * @return string|null
     */
    public function getPropertyKind()
    {
        return $this->PropertyKind;
    }
    /**
     * Set PropertyKind value
     * @uses \EnumType\ObligationPropertyKindType::valueIsValid()
     * @uses \EnumType\ObligationPropertyKindType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyKind
     * @return \StructType\ReportPropertyType
     */
    public function setPropertyKind($propertyKind = null)
    {
        $this->PropertyKind = $propertyKind;
        return $this;
    }
    /**
     * Get CauseArrest value
     * @return string|null
     */
    public function getCauseArrest()
    {
        return $this->CauseArrest;
    }
    /**
     * Set CauseArrest value
     * @param string $causeArrest
     * @return \StructType\ReportPropertyType
     */
    public function setCauseArrest($causeArrest = null)
    {
        $this->CauseArrest = $causeArrest;
        return $this;
    }
    /**
     * Get Ban value
     * @return string|null
     */
    public function getBan()
    {
        return $this->Ban;
    }
    /**
     * Set Ban value
     * @uses \EnumType\BanType::valueIsValid()
     * @uses \EnumType\BanType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ban
     * @return \StructType\ReportPropertyType
     */
    public function setBan($ban = null)
    {
        $this->Ban = $ban;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ReportPropertyType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ReportPropertyType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\ReportPropertyType
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\ReportPropertyType
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportPropertyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
