<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Report StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ Report «Уведомление об исполнении» | Содержит уведомление об исполнении | ЭП
 * - type: tns:Report
 * @subpackage Structs
 */
class Report extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор уведомления, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The RestrictnInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления ФССП России | Уникальный идентификатор постановления, присвоенный АИС ФССП России и переданный ранее
     * внешнему контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $RestrictnInternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП России и переданный ранее
     * внешнему контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата уведомления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер уведомления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The RestrDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления об ограничении | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RestrDocDate;
    /**
     * The RestrDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления об ограничении | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RestrDocNumber;
    /**
     * The RestrictionAnswerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ответа
     * @var string
     */
    public $RestrictionAnswerType;
    /**
     * The LegalImpossibility
     * Meta informations extracted from the WSDL
     * - documentation: Причины невозможности исполнения требований СПИ | Указывается причина невозможности исполнения требования указанных в
     * постановлении. Обязательно к заполнению, если тип ответа "2" | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $LegalImpossibility;
    /**
     * The RestrictedAmount
     * Meta informations extracted from the WSDL
     * - documentation: Общая сумма ареста/взыскания на счете в валюте счета | Указывается сумма ареста (снятия ареста)/взыскания (прекращения
     * обращения взыскания) на счете в валюте счета. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RestrictedAmount;
    /**
     * The RestrictedAmountRub
     * Meta informations extracted from the WSDL
     * - documentation: Общая сумма ареста/взыскания на счете в рублёвом эквиваленте | Указывается сумма ареста (снятия ареста)/взыскания (прекращения
     * обращения взыскания) на счете в рублёвом эквиваленте. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RestrictedAmountRub;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения об исполнении Постановления к исполнению. Содержит список наложенных ограничений (арестов)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The RestrictedData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наложенных ограничениях | Данные, передаваемые в этих полях должны включать в себя все сведения об ограничениях,
     * переданные ранее документом «Постановление к исполнению»
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $RestrictedData;
    /**
     * The NonRestrictedData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об ограничениях, наложение которых невозможно | Данные, передаваемые в этих полях должны включать в себя все сведения
     * об ограничениях, переданные ранее документом «Постановление к исполнению»
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $NonRestrictedData;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Report
     * @uses Report::setExternalKey()
     * @uses Report::setRestrictnInternalKey()
     * @uses Report::setIpInternalKey()
     * @uses Report::setDocDate()
     * @uses Report::setDocNumber()
     * @uses Report::setRestrDocDate()
     * @uses Report::setRestrDocNumber()
     * @uses Report::setRestrictionAnswerType()
     * @uses Report::setLegalImpossibility()
     * @uses Report::setRestrictedAmount()
     * @uses Report::setRestrictedAmountRub()
     * @uses Report::setData()
     * @uses Report::setRestrictedData()
     * @uses Report::setNonRestrictedData()
     * @uses Report::setSignDateTime()
     * @uses Report::setSignature()
     * @uses Report::setId()
     * @param string $externalKey
     * @param int $restrictnInternalKey
     * @param int $ipInternalKey
     * @param string $docDate
     * @param string $docNumber
     * @param string $restrDocDate
     * @param string $restrDocNumber
     * @param string $restrictionAnswerType
     * @param string $legalImpossibility
     * @param float $restrictedAmount
     * @param float $restrictedAmountRub
     * @param \StructType\Data[] $data
     * @param \StructType\Data[] $restrictedData
     * @param \StructType\Data[] $nonRestrictedData
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $restrictnInternalKey = null, $ipInternalKey = null, $docDate = null, $docNumber = null, $restrDocDate = null, $restrDocNumber = null, $restrictionAnswerType = null, $legalImpossibility = null, $restrictedAmount = null, $restrictedAmountRub = null, array $data = array(), array $restrictedData = array(), array $nonRestrictedData = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setRestrictnInternalKey($restrictnInternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setRestrDocDate($restrDocDate)
            ->setRestrDocNumber($restrDocNumber)
            ->setRestrictionAnswerType($restrictionAnswerType)
            ->setLegalImpossibility($legalImpossibility)
            ->setRestrictedAmount($restrictedAmount)
            ->setRestrictedAmountRub($restrictedAmountRub)
            ->setData($data)
            ->setRestrictedData($restrictedData)
            ->setNonRestrictedData($nonRestrictedData)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\Report
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get RestrictnInternalKey value
     * @return int|null
     */
    public function getRestrictnInternalKey()
    {
        return $this->RestrictnInternalKey;
    }
    /**
     * Set RestrictnInternalKey value
     * @param int $restrictnInternalKey
     * @return \StructType\Report
     */
    public function setRestrictnInternalKey($restrictnInternalKey = null)
    {
        $this->RestrictnInternalKey = $restrictnInternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\Report
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\Report
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\Report
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get RestrDocDate value
     * @return string|null
     */
    public function getRestrDocDate()
    {
        return $this->RestrDocDate;
    }
    /**
     * Set RestrDocDate value
     * @param string $restrDocDate
     * @return \StructType\Report
     */
    public function setRestrDocDate($restrDocDate = null)
    {
        $this->RestrDocDate = $restrDocDate;
        return $this;
    }
    /**
     * Get RestrDocNumber value
     * @return string|null
     */
    public function getRestrDocNumber()
    {
        return $this->RestrDocNumber;
    }
    /**
     * Set RestrDocNumber value
     * @param string $restrDocNumber
     * @return \StructType\Report
     */
    public function setRestrDocNumber($restrDocNumber = null)
    {
        $this->RestrDocNumber = $restrDocNumber;
        return $this;
    }
    /**
     * Get RestrictionAnswerType value
     * @return string|null
     */
    public function getRestrictionAnswerType()
    {
        return $this->RestrictionAnswerType;
    }
    /**
     * Set RestrictionAnswerType value
     * @uses \EnumType\RestrictionAnswerType::valueIsValid()
     * @uses \EnumType\RestrictionAnswerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionAnswerType
     * @return \StructType\Report
     */
    public function setRestrictionAnswerType($restrictionAnswerType = null)
    {
        $this->RestrictionAnswerType = $restrictionAnswerType;
        return $this;
    }
    /**
     * Get LegalImpossibility value
     * @return string|null
     */
    public function getLegalImpossibility()
    {
        return $this->LegalImpossibility;
    }
    /**
     * Set LegalImpossibility value
     * @param string $legalImpossibility
     * @return \StructType\Report
     */
    public function setLegalImpossibility($legalImpossibility = null)
    {
        $this->LegalImpossibility = $legalImpossibility;
        return $this;
    }
    /**
     * Get RestrictedAmount value
     * @return float|null
     */
    public function getRestrictedAmount()
    {
        return $this->RestrictedAmount;
    }
    /**
     * Set RestrictedAmount value
     * @param float $restrictedAmount
     * @return \StructType\Report
     */
    public function setRestrictedAmount($restrictedAmount = null)
    {
        $this->RestrictedAmount = $restrictedAmount;
        return $this;
    }
    /**
     * Get RestrictedAmountRub value
     * @return float|null
     */
    public function getRestrictedAmountRub()
    {
        return $this->RestrictedAmountRub;
    }
    /**
     * Set RestrictedAmountRub value
     * @param float $restrictedAmountRub
     * @return \StructType\Report
     */
    public function setRestrictedAmountRub($restrictedAmountRub = null)
    {
        $this->RestrictedAmountRub = $restrictedAmountRub;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\Report
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Report
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get RestrictedData value
     * @return \StructType\Data[]|null
     */
    public function getRestrictedData()
    {
        return $this->RestrictedData;
    }
    /**
     * Set RestrictedData value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $restrictedData
     * @return \StructType\Report
     */
    public function setRestrictedData(array $restrictedData = array())
    {
        $this->RestrictedData = $restrictedData;
        return $this;
    }
    /**
     * Add item to RestrictedData value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Report
     */
    public function addToRestrictedData(\StructType\Data $item)
    {
        $this->RestrictedData[] = $item;
        return $this;
    }
    /**
     * Get NonRestrictedData value
     * @return \StructType\Data[]|null
     */
    public function getNonRestrictedData()
    {
        return $this->NonRestrictedData;
    }
    /**
     * Set NonRestrictedData value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $nonRestrictedData
     * @return \StructType\Report
     */
    public function setNonRestrictedData(array $nonRestrictedData = array())
    {
        $this->NonRestrictedData = $nonRestrictedData;
        return $this;
    }
    /**
     * Add item to NonRestrictedData value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Report
     */
    public function addToNonRestrictedData(\StructType\Data $item)
    {
        $this->NonRestrictedData[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\Report
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\Report
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\Report
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Report
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Report
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
