<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistryFileResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ для передачи реестров и справочников ФССП России
 * - type: tns:RegistryFileResponse
 * @subpackage Structs
 */
class RegistryFileResponse extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время реестра | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * - minOccurs: 0
     * @var string
     */
    public $TypeDoc;
    /**
     * The FileUID
     * Meta informations extracted from the WSDL
     * - documentation: Ссылка на файл со справочником или реестром | UID документа
     * - minOccurs: 0
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $FileUID;
    /**
     * The HasMore
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия реестров в очереди | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $HasMore;
    /**
     * Constructor method for RegistryFileResponse
     * @uses RegistryFileResponse::setInternalKey()
     * @uses RegistryFileResponse::setRequestExternalKey()
     * @uses RegistryFileResponse::setUnloadDate()
     * @uses RegistryFileResponse::setTypeDoc()
     * @uses RegistryFileResponse::setFileUID()
     * @uses RegistryFileResponse::setHasMore()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param string $unloadDate
     * @param string $typeDoc
     * @param string $fileUID
     * @param bool $hasMore
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $unloadDate = null, $typeDoc = null, $fileUID = null, $hasMore = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setUnloadDate($unloadDate)
            ->setTypeDoc($typeDoc)
            ->setFileUID($fileUID)
            ->setHasMore($hasMore);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\RegistryFileResponse
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\RegistryFileResponse
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\RegistryFileResponse
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @uses \EnumType\RegistryDocType::valueIsValid()
     * @uses \EnumType\RegistryDocType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeDoc
     * @return \StructType\RegistryFileResponse
     */
    public function setTypeDoc($typeDoc = null)
    {
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get FileUID value
     * @return string|null
     */
    public function getFileUID()
    {
        return $this->FileUID;
    }
    /**
     * Set FileUID value
     * @param string $fileUID
     * @return \StructType\RegistryFileResponse
     */
    public function setFileUID($fileUID = null)
    {
        $this->FileUID = $fileUID;
        return $this;
    }
    /**
     * Get HasMore value
     * @return bool|null
     */
    public function getHasMore()
    {
        return $this->HasMore;
    }
    /**
     * Set HasMore value
     * @param bool $hasMore
     * @return \StructType\RegistryFileResponse
     */
    public function setHasMore($hasMore = null)
    {
        $this->HasMore = $hasMore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegistryFileResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
