<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных «Данные справочника» используется для передачи данных одного справочника в документе «Информация справочника»
 * @subpackage Structs
 */
class ReferenceDataType extends AbstractStructBase
{
    /**
     * The referenceCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида справочника
     * - minOccurs: 1
     * @var string
     */
    public $referenceCode;
    /**
     * The osp
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника ВКСП | Используется только один тип передаваемых данных в соответствии со значением поля «Код вида
     * справочника»
     * @var \StructType\OspProperty
     */
    public $osp;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника «Валюты»
     * @var \StructType\CurrencyProperty
     */
    public $currency;
    /**
     * The idDocType
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника «Типы документов, удостоверяющих личность»
     * @var \StructType\IdDocTypeProperty
     */
    public $idDocType;
    /**
     * Constructor method for ReferenceDataType
     * @uses ReferenceDataType::setReferenceCode()
     * @uses ReferenceDataType::setOsp()
     * @uses ReferenceDataType::setCurrency()
     * @uses ReferenceDataType::setIdDocType()
     * @param string $referenceCode
     * @param \StructType\OspProperty $osp
     * @param \StructType\CurrencyProperty $currency
     * @param \StructType\IdDocTypeProperty $idDocType
     */
    public function __construct($referenceCode = null, \StructType\OspProperty $osp = null, \StructType\CurrencyProperty $currency = null, \StructType\IdDocTypeProperty $idDocType = null)
    {
        $this
            ->setReferenceCode($referenceCode)
            ->setOsp($osp)
            ->setCurrency($currency)
            ->setIdDocType($idDocType);
    }
    /**
     * Get referenceCode value
     * @return string
     */
    public function getReferenceCode()
    {
        return $this->referenceCode;
    }
    /**
     * Set referenceCode value
     * @uses \EnumType\LookupTableType::valueIsValid()
     * @uses \EnumType\LookupTableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $referenceCode
     * @return \StructType\ReferenceDataType
     */
    public function setReferenceCode($referenceCode = null)
    {
        $this->referenceCode = $referenceCode;
        return $this;
    }
    /**
     * Get osp value
     * @return \StructType\OspProperty|null
     */
    public function getOsp()
    {
        return $this->osp;
    }
    /**
     * Set osp value
     * @param \StructType\OspProperty $osp
     * @return \StructType\ReferenceDataType
     */
    public function setOsp(\StructType\OspProperty $osp = null)
    {
        $this->osp = $osp;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\CurrencyProperty|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\CurrencyProperty $currency
     * @return \StructType\ReferenceDataType
     */
    public function setCurrency(\StructType\CurrencyProperty $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get idDocType value
     * @return \StructType\IdDocTypeProperty|null
     */
    public function getIdDocType()
    {
        return $this->idDocType;
    }
    /**
     * Set idDocType value
     * @param \StructType\IdDocTypeProperty $idDocType
     * @return \StructType\ReferenceDataType
     */
    public function setIdDocType(\StructType\IdDocTypeProperty $idDocType = null)
    {
        $this->idDocType = $idDocType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
