<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecoveringIpInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на запрос о полученных физическим лицом суммах, взысканных по ИП
 * @subpackage Structs
 */
class RecoveringIpInfoType extends AbstractStructBase
{
    /**
     * The Plaintiff
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель
     * @var \StructType\ContragentDatumType
     */
    public $Plaintiff;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об ИП
     * @var \StructType\IP
     */
    public $IP;
    /**
     * The RecoveredAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о взысканных суммах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecoveredAmountType[]
     */
    public $RecoveredAmount;
    /**
     * Constructor method for RecoveringIpInfoType
     * @uses RecoveringIpInfoType::setPlaintiff()
     * @uses RecoveringIpInfoType::setIP()
     * @uses RecoveringIpInfoType::setRecoveredAmount()
     * @param \StructType\ContragentDatumType $plaintiff
     * @param \StructType\IP $iP
     * @param \StructType\RecoveredAmountType[] $recoveredAmount
     */
    public function __construct(\StructType\ContragentDatumType $plaintiff = null, \StructType\IP $iP = null, array $recoveredAmount = array())
    {
        $this
            ->setPlaintiff($plaintiff)
            ->setIP($iP)
            ->setRecoveredAmount($recoveredAmount);
    }
    /**
     * Get Plaintiff value
     * @return \StructType\ContragentDatumType|null
     */
    public function getPlaintiff()
    {
        return $this->Plaintiff;
    }
    /**
     * Set Plaintiff value
     * @param \StructType\ContragentDatumType $plaintiff
     * @return \StructType\RecoveringIpInfoType
     */
    public function setPlaintiff(\StructType\ContragentDatumType $plaintiff = null)
    {
        $this->Plaintiff = $plaintiff;
        return $this;
    }
    /**
     * Get IP value
     * @return \StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \StructType\IP $iP
     * @return \StructType\RecoveringIpInfoType
     */
    public function setIP(\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get RecoveredAmount value
     * @return \StructType\RecoveredAmountType[]|null
     */
    public function getRecoveredAmount()
    {
        return $this->RecoveredAmount;
    }
    /**
     * Set RecoveredAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveredAmountType[] $recoveredAmount
     * @return \StructType\RecoveringIpInfoType
     */
    public function setRecoveredAmount(array $recoveredAmount = array())
    {
        $this->RecoveredAmount = $recoveredAmount;
        return $this;
    }
    /**
     * Add item to RecoveredAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveredAmountType $item
     * @return \StructType\RecoveringIpInfoType
     */
    public function addToRecoveredAmount(\StructType\RecoveredAmountType $item)
    {
        $this->RecoveredAmount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecoveringIpInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
