<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecoveredAmountRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос о полученных физическим лицом суммах, взысканных по ИП
 * - type: tns:RecoveredAmountRequest
 * @subpackage Structs
 */
class RecoveredAmountRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The Plaintiff
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель
     * @var \StructType\ContragentDatumType
     */
    public $Plaintiff;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - documentation: Начало периода | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - documentation: Окончание периода | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EndDate;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RecoveredAmountRequest
     * @uses RecoveredAmountRequest::setExternalKey()
     * @uses RecoveredAmountRequest::setPlaintiff()
     * @uses RecoveredAmountRequest::setBeginDate()
     * @uses RecoveredAmountRequest::setEndDate()
     * @uses RecoveredAmountRequest::setSignature()
     * @uses RecoveredAmountRequest::setId()
     * @param string $externalKey
     * @param \StructType\ContragentDatumType $plaintiff
     * @param string $beginDate
     * @param string $endDate
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, \StructType\ContragentDatumType $plaintiff = null, $beginDate = null, $endDate = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setPlaintiff($plaintiff)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\RecoveredAmountRequest
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get Plaintiff value
     * @return \StructType\ContragentDatumType|null
     */
    public function getPlaintiff()
    {
        return $this->Plaintiff;
    }
    /**
     * Set Plaintiff value
     * @param \StructType\ContragentDatumType $plaintiff
     * @return \StructType\RecoveredAmountRequest
     */
    public function setPlaintiff(\StructType\ContragentDatumType $plaintiff = null)
    {
        $this->Plaintiff = $plaintiff;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\RecoveredAmountRequest
     */
    public function setBeginDate($beginDate = null)
    {
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\RecoveredAmountRequest
     */
    public function setEndDate($endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\RecoveredAmountRequest
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\RecoveredAmountRequest
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RecoveredAmountRequest
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecoveredAmountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
