<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecoveredAmountAnswer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на запрос о полученных физическим лицом суммах, взысканных по ИП
 * - type: tns:RecoveredAmountAnswer
 * @subpackage Structs
 */
class RecoveredAmountAnswer extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The Plaintiff
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель
     * @var \StructType\ContragentDatumType
     */
    public $Plaintiff;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - documentation: Начало периода | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - documentation: Окончание периода | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EndDate;
    /**
     * The RecoveringIpInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о взысканных суммах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecoveringIpInfoType[]
     */
    public $RecoveringIpInfo;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RecoveredAmountAnswer
     * @uses RecoveredAmountAnswer::setInternalKey()
     * @uses RecoveredAmountAnswer::setRequestExternalKey()
     * @uses RecoveredAmountAnswer::setPlaintiff()
     * @uses RecoveredAmountAnswer::setBeginDate()
     * @uses RecoveredAmountAnswer::setEndDate()
     * @uses RecoveredAmountAnswer::setRecoveringIpInfo()
     * @uses RecoveredAmountAnswer::setSignature()
     * @uses RecoveredAmountAnswer::setId()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param \StructType\ContragentDatumType $plaintiff
     * @param string $beginDate
     * @param string $endDate
     * @param \StructType\RecoveringIpInfoType[] $recoveringIpInfo
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestExternalKey = null, \StructType\ContragentDatumType $plaintiff = null, $beginDate = null, $endDate = null, array $recoveringIpInfo = array(), array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setPlaintiff($plaintiff)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setRecoveringIpInfo($recoveringIpInfo)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get Plaintiff value
     * @return \StructType\ContragentDatumType|null
     */
    public function getPlaintiff()
    {
        return $this->Plaintiff;
    }
    /**
     * Set Plaintiff value
     * @param \StructType\ContragentDatumType $plaintiff
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setPlaintiff(\StructType\ContragentDatumType $plaintiff = null)
    {
        $this->Plaintiff = $plaintiff;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setBeginDate($beginDate = null)
    {
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setEndDate($endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get RecoveringIpInfo value
     * @return \StructType\RecoveringIpInfoType[]|null
     */
    public function getRecoveringIpInfo()
    {
        return $this->RecoveringIpInfo;
    }
    /**
     * Set RecoveringIpInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveringIpInfoType[] $recoveringIpInfo
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setRecoveringIpInfo(array $recoveringIpInfo = array())
    {
        $this->RecoveringIpInfo = $recoveringIpInfo;
        return $this;
    }
    /**
     * Add item to RecoveringIpInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveringIpInfoType $item
     * @return \StructType\RecoveredAmountAnswer
     */
    public function addToRecoveringIpInfo(\StructType\RecoveringIpInfoType $item)
    {
        $this->RecoveringIpInfo[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\RecoveredAmountAnswer
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RecoveredAmountAnswer
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecoveredAmountAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
