<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecallDoc StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ RecallDoc «Заявление об отзыве ИД» | Содержит сведения Заявления об отзыве Постановления о взыскании страховых взносов,
 * пеней и штрафов за счет имущества плательщика страховых взносов, направленного в ОСП ранее | ЭП
 * - type: tns:RecallDoc
 * @subpackage Structs
 */
class RecallDoc extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор заявления, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, полученного ранее от АИС внешнего контрагента. Заполняется
     * в том случае, если ИД был получен ранее от АИС того же внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего
     * контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве
     * обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, ведущего ИП | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ, ведущего ИП | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ, ведущего ИП | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The ClaimerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип взыскателя
     * @var string
     */
    public $ClaimerType;
    /**
     * The ClaimerName
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель | Наименование взыскателя, отменяющего ИД | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ClaimerName;
    /**
     * The OrganSignPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность подписавшего лица | Должность должностного лица, подписавшего Заявление | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OrganSignPost;
    /**
     * The OrganSignFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО подписавшего лица | ФИО должностного лица, подписавшего Заявление | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OrganSignFIO;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Вид исполнительного документа | Вид отменяемого ИД
     * @var string
     */
    public $IDType;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ИД | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Должник | Полное наименование должника (для ЮЛ и ИП), ФИО полностью должника для ФЛ | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Адрес должника по ИД | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата рождения должника, для ФЛ обязательное | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Для физических лиц обязательно | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorBirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения | Место рождения должника, для ФЛ обязательное | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorBirthPlace;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника | ИНН должника ЮЛ/ИП | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП должника | Код причины постановки на учет ЮЛ | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | ОГРН/ОГРНИП ЮЛ/ИП | Основной государственный регистрационный номер (ОГРН)/Основной государственный
     * регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The DebtorNo
     * Meta informations extracted from the WSDL
     * - documentation: Рег. номер должника | Регистрационный номер должника, присвоенный органом, выдавшим ИД | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $DebtorNo;
    /**
     * The Subj
     * Meta informations extracted from the WSDL
     * - documentation: Предмет | Включает в себя резолютивную часть Заявления о прекращении исполнительных действий | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Subj;
    /**
     * The IDRecall
     * Meta informations extracted from the WSDL
     * - documentation: Отзыв | Отметка о необходимости возврата ИД | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IDRecall;
    /**
     * The RecallDocBase
     * Meta informations extracted from the WSDL
     * - documentation: Заявление об отзыве ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $RecallDocBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП Заявление об отзыве ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения о должнике
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RecallDoc
     * @uses RecallDoc::setExternalKey()
     * @uses RecallDoc::setIdExternalKey()
     * @uses RecallDoc::setDocDate()
     * @uses RecallDoc::setDocNumber()
     * @uses RecallDoc::setSPI()
     * @uses RecallDoc::setSPIFio()
     * @uses RecallDoc::setSPIPost()
     * @uses RecallDoc::setClaimerType()
     * @uses RecallDoc::setClaimerName()
     * @uses RecallDoc::setOrganSignPost()
     * @uses RecallDoc::setOrganSignFIO()
     * @uses RecallDoc::setIDType()
     * @uses RecallDoc::setIDNum()
     * @uses RecallDoc::setIDDate()
     * @uses RecallDoc::setIDSum()
     * @uses RecallDoc::setDebtorType()
     * @uses RecallDoc::setDebtorName()
     * @uses RecallDoc::setDebtorAdr()
     * @uses RecallDoc::setDebtorBirthDate()
     * @uses RecallDoc::setDebtorBirthYear()
     * @uses RecallDoc::setDebtorBirthPlace()
     * @uses RecallDoc::setDebtorINN()
     * @uses RecallDoc::setDebtorKPP()
     * @uses RecallDoc::setDebtorOGRN()
     * @uses RecallDoc::setDebtorNo()
     * @uses RecallDoc::setSubj()
     * @uses RecallDoc::setIDRecall()
     * @uses RecallDoc::setRecallDocBase()
     * @uses RecallDoc::setSignatureBase()
     * @uses RecallDoc::setData()
     * @uses RecallDoc::setSignDateTime()
     * @uses RecallDoc::setSignature()
     * @uses RecallDoc::setId()
     * @param string $externalKey
     * @param string $idExternalKey
     * @param string $docDate
     * @param string $docNumber
     * @param int $sPI
     * @param string $sPIFio
     * @param string $sPIPost
     * @param string $claimerType
     * @param string $claimerName
     * @param string $organSignPost
     * @param string $organSignFIO
     * @param string $iDType
     * @param string $iDNum
     * @param string $iDDate
     * @param float $iDSum
     * @param string $debtorType
     * @param string $debtorName
     * @param string $debtorAdr
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorBirthPlace
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorOGRN
     * @param string $debtorNo
     * @param string $subj
     * @param bool $iDRecall
     * @param string $recallDocBase
     * @param string $signatureBase
     * @param \StructType\Data[] $data
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $idExternalKey = null, $docDate = null, $docNumber = null, $sPI = null, $sPIFio = null, $sPIPost = null, $claimerType = null, $claimerName = null, $organSignPost = null, $organSignFIO = null, $iDType = null, $iDNum = null, $iDDate = null, $iDSum = null, $debtorType = null, $debtorName = null, $debtorAdr = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorBirthPlace = null, $debtorINN = null, $debtorKPP = null, $debtorOGRN = null, $debtorNo = null, $subj = null, $iDRecall = null, $recallDocBase = null, $signatureBase = null, array $data = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setIdExternalKey($idExternalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPIPost($sPIPost)
            ->setClaimerType($claimerType)
            ->setClaimerName($claimerName)
            ->setOrganSignPost($organSignPost)
            ->setOrganSignFIO($organSignFIO)
            ->setIDType($iDType)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setIDSum($iDSum)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorBirthPlace($debtorBirthPlace)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorOGRN($debtorOGRN)
            ->setDebtorNo($debtorNo)
            ->setSubj($subj)
            ->setIDRecall($iDRecall)
            ->setRecallDocBase($recallDocBase)
            ->setSignatureBase($signatureBase)
            ->setData($data)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\RecallDoc
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \StructType\RecallDoc
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\RecallDoc
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\RecallDoc
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \StructType\RecallDoc
     */
    public function setSPI($sPI = null)
    {
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\RecallDoc
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\RecallDoc
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get ClaimerType value
     * @return string|null
     */
    public function getClaimerType()
    {
        return $this->ClaimerType;
    }
    /**
     * Set ClaimerType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimerType
     * @return \StructType\RecallDoc
     */
    public function setClaimerType($claimerType = null)
    {
        $this->ClaimerType = $claimerType;
        return $this;
    }
    /**
     * Get ClaimerName value
     * @return string|null
     */
    public function getClaimerName()
    {
        return $this->ClaimerName;
    }
    /**
     * Set ClaimerName value
     * @param string $claimerName
     * @return \StructType\RecallDoc
     */
    public function setClaimerName($claimerName = null)
    {
        $this->ClaimerName = $claimerName;
        return $this;
    }
    /**
     * Get OrganSignPost value
     * @return string|null
     */
    public function getOrganSignPost()
    {
        return $this->OrganSignPost;
    }
    /**
     * Set OrganSignPost value
     * @param string $organSignPost
     * @return \StructType\RecallDoc
     */
    public function setOrganSignPost($organSignPost = null)
    {
        $this->OrganSignPost = $organSignPost;
        return $this;
    }
    /**
     * Get OrganSignFIO value
     * @return string|null
     */
    public function getOrganSignFIO()
    {
        return $this->OrganSignFIO;
    }
    /**
     * Set OrganSignFIO value
     * @param string $organSignFIO
     * @return \StructType\RecallDoc
     */
    public function setOrganSignFIO($organSignFIO = null)
    {
        $this->OrganSignFIO = $organSignFIO;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \EnumType\IdType::valueIsValid()
     * @uses \EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \StructType\RecallDoc
     */
    public function setIDType($iDType = null)
    {
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \StructType\RecallDoc
     */
    public function setIDNum($iDNum = null)
    {
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \StructType\RecallDoc
     */
    public function setIDDate($iDDate = null)
    {
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \StructType\RecallDoc
     */
    public function setIDSum($iDSum = null)
    {
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \StructType\RecallDoc
     */
    public function setDebtorType($debtorType = null)
    {
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \StructType\RecallDoc
     */
    public function setDebtorName($debtorName = null)
    {
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \StructType\RecallDoc
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \StructType\RecallDoc
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \StructType\RecallDoc
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorBirthPlace value
     * @return string|null
     */
    public function getDebtorBirthPlace()
    {
        return $this->DebtorBirthPlace;
    }
    /**
     * Set DebtorBirthPlace value
     * @param string $debtorBirthPlace
     * @return \StructType\RecallDoc
     */
    public function setDebtorBirthPlace($debtorBirthPlace = null)
    {
        $this->DebtorBirthPlace = $debtorBirthPlace;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \StructType\RecallDoc
     */
    public function setDebtorINN($debtorINN = null)
    {
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \StructType\RecallDoc
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \StructType\RecallDoc
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get DebtorNo value
     * @return string|null
     */
    public function getDebtorNo()
    {
        return $this->DebtorNo;
    }
    /**
     * Set DebtorNo value
     * @param string $debtorNo
     * @return \StructType\RecallDoc
     */
    public function setDebtorNo($debtorNo = null)
    {
        $this->DebtorNo = $debtorNo;
        return $this;
    }
    /**
     * Get Subj value
     * @return string|null
     */
    public function getSubj()
    {
        return $this->Subj;
    }
    /**
     * Set Subj value
     * @param string $subj
     * @return \StructType\RecallDoc
     */
    public function setSubj($subj = null)
    {
        $this->Subj = $subj;
        return $this;
    }
    /**
     * Get IDRecall value
     * @return bool|null
     */
    public function getIDRecall()
    {
        return $this->IDRecall;
    }
    /**
     * Set IDRecall value
     * @param bool $iDRecall
     * @return \StructType\RecallDoc
     */
    public function setIDRecall($iDRecall = null)
    {
        $this->IDRecall = $iDRecall;
        return $this;
    }
    /**
     * Get RecallDocBase value
     * @return string|null
     */
    public function getRecallDocBase()
    {
        return $this->RecallDocBase;
    }
    /**
     * Set RecallDocBase value
     * @param string $recallDocBase
     * @return \StructType\RecallDoc
     */
    public function setRecallDocBase($recallDocBase = null)
    {
        $this->RecallDocBase = $recallDocBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \StructType\RecallDoc
     */
    public function setSignatureBase($signatureBase = null)
    {
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\RecallDoc
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\RecallDoc
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\RecallDoc
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\RecallDoc
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\RecallDoc
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RecallDoc
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecallDoc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
