<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicEnityType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о субъекте публичного права
 * @subpackage Structs
 */
class PublicEnityType extends OrganizationDatumType
{
    /**
     * The entityType
     * Meta informations extracted from the WSDL
     * - documentation: Класс контрагента | Класс контрагента
     * @var int
     */
    public $entityType;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: Код ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер регистрационной записи | Строка длиной от 1 до 45 символов
     * - minOccurs: 0
     * - maxLength: 45
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата государственной регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * The regDateregCountry
     * Meta informations extracted from the WSDL
     * - documentation: Полное наименование страны регистрации | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $regDateregCountry;
    /**
     * Constructor method for PublicEnityType
     * @uses PublicEnityType::setEntityType()
     * @uses PublicEnityType::setOKATO()
     * @uses PublicEnityType::setRegNumber()
     * @uses PublicEnityType::setRegDate()
     * @uses PublicEnityType::setRegDateregCountry()
     * @param int $entityType
     * @param string $oKATO
     * @param string $regNumber
     * @param string $regDate
     * @param string $regDateregCountry
     */
    public function __construct($entityType = null, $oKATO = null, $regNumber = null, $regDate = null, $regDateregCountry = null)
    {
        $this
            ->setEntityType($entityType)
            ->setOKATO($oKATO)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate)
            ->setRegDateregCountry($regDateregCountry);
    }
    /**
     * Get entityType value
     * @return int|null
     */
    public function getEntityType()
    {
        return $this->entityType;
    }
    /**
     * Set entityType value
     * @param int $entityType
     * @return \StructType\PublicEnityType
     */
    public function setEntityType($entityType = null)
    {
        $this->entityType = $entityType;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \StructType\PublicEnityType
     */
    public function setOKATO($oKATO = null)
    {
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \StructType\PublicEnityType
     */
    public function setRegNumber($regNumber = null)
    {
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \StructType\PublicEnityType
     */
    public function setRegDate($regDate = null)
    {
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Get regDateregCountry value
     * @return string|null
     */
    public function getRegDateregCountry()
    {
        return $this->regDateregCountry;
    }
    /**
     * Set regDateregCountry value
     * @param string $regDateregCountry
     * @return \StructType\PublicEnityType
     */
    public function setRegDateregCountry($regDateregCountry = null)
    {
        $this->regDateregCountry = $regDateregCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublicEnityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
