<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyObligationDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об имущественных обязательствах
 * @subpackage Structs
 */
class PropertyObligationDatumType extends InformationType
{
    /**
     * The ContractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер договора | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ContractNumber;
    /**
     * The ContractDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ContractDate;
    /**
     * The ContractEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания договора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ContractEndDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма договора | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The PropertyKind
     * Meta informations extracted from the WSDL
     * - documentation: Имущество
     * - minOccurs: 0
     * @var string
     */
    public $PropertyKind;
    /**
     * The PropertyType
     * Meta informations extracted from the WSDL
     * - documentation: Тип имущества
     * - minOccurs: 0
     * @var string
     */
    public $PropertyType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Общее описание | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PropertyObligationDatumType
     * @uses PropertyObligationDatumType::setContractNumber()
     * @uses PropertyObligationDatumType::setContractDate()
     * @uses PropertyObligationDatumType::setContractEndDate()
     * @uses PropertyObligationDatumType::setAmount()
     * @uses PropertyObligationDatumType::setPropertyKind()
     * @uses PropertyObligationDatumType::setPropertyType()
     * @uses PropertyObligationDatumType::setDescription()
     * @param string $contractNumber
     * @param string $contractDate
     * @param string $contractEndDate
     * @param float $amount
     * @param string $propertyKind
     * @param string $propertyType
     * @param string $description
     */
    public function __construct($contractNumber = null, $contractDate = null, $contractEndDate = null, $amount = null, $propertyKind = null, $propertyType = null, $description = null)
    {
        $this
            ->setContractNumber($contractNumber)
            ->setContractDate($contractDate)
            ->setContractEndDate($contractEndDate)
            ->setAmount($amount)
            ->setPropertyKind($propertyKind)
            ->setPropertyType($propertyType)
            ->setDescription($description);
    }
    /**
     * Get ContractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \StructType\PropertyObligationDatumType
     */
    public function setContractNumber($contractNumber = null)
    {
        $this->ContractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get ContractDate value
     * @return string|null
     */
    public function getContractDate()
    {
        return $this->ContractDate;
    }
    /**
     * Set ContractDate value
     * @param string $contractDate
     * @return \StructType\PropertyObligationDatumType
     */
    public function setContractDate($contractDate = null)
    {
        $this->ContractDate = $contractDate;
        return $this;
    }
    /**
     * Get ContractEndDate value
     * @return string|null
     */
    public function getContractEndDate()
    {
        return $this->ContractEndDate;
    }
    /**
     * Set ContractEndDate value
     * @param string $contractEndDate
     * @return \StructType\PropertyObligationDatumType
     */
    public function setContractEndDate($contractEndDate = null)
    {
        $this->ContractEndDate = $contractEndDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PropertyObligationDatumType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PropertyKind value
     * @return string|null
     */
    public function getPropertyKind()
    {
        return $this->PropertyKind;
    }
    /**
     * Set PropertyKind value
     * @uses \EnumType\ObligationPropertyKindType::valueIsValid()
     * @uses \EnumType\ObligationPropertyKindType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyKind
     * @return \StructType\PropertyObligationDatumType
     */
    public function setPropertyKind($propertyKind = null)
    {
        $this->PropertyKind = $propertyKind;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return string|null
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @uses \EnumType\ObligationPropertyType::valueIsValid()
     * @uses \EnumType\ObligationPropertyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyType
     * @return \StructType\PropertyObligationDatumType
     */
    public function setPropertyType($propertyType = null)
    {
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PropertyObligationDatumType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyObligationDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
