<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcDoc StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ProcDoc «Постановление СПИ» | Содержит сведения о постановлении СПИ, направленном в адрес стороны ИП | ЭП
 * - type: tns:ProcDoc
 * @subpackage Structs
 */
class ProcDoc extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор постановления, присвоенный АИС ФССП России | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, вынесшего постановление | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ, утвердившего документ | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ, утвердившего документ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих-код | Штрих-код документа в формате code 39. Значение этого поля имеет формат: «NNNNNNNNN/DDDD-Y...Y», где NNNNNNNNN — числовой
     * идентификатор документа, DDDD — код отдела СП по справочнику ВКСП, Y...Y -номер копии. | Штрих-код в формате code39
     * - minOccurs: 0
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип постановления | Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного
     * документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The Sum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Содержит сумму, указанную в постановлении | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Sum;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Основание решения СПИ | Текст основания принятия решения | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Reason;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - documentation: Статья | Статья основания решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Article;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Point;
    /**
     * The Part
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт | Подпункт статьи основания решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Part;
    /**
     * The NewOspCode
     * Meta informations extracted from the WSDL
     * - documentation: Номер отдела в который передается ИП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $NewOspCode;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - documentation: ДатаНачалаПериода | Дата начала периода приостановление, отложения, рассрочки, отсрочки | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - documentation: ДатаОкончанияПериода | Дата окончания периода приостановление, отложения, рассрочки, отсрочки | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EndDate;
    /**
     * The ResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Оригинал постановления СПИ, вынесенного в соответствии с Приказом ФССП России от 22.04.2015 № 248 «Об
     * утверждении требований к формату постановления судебного пристава-исполнителя или иного должностного лица Федеральной службы
     * судебных приставов, вынесенного в форме электронного документа» в форме электронного документа в формате в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $ResolutionBase;
    /**
     * The SignatureResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП постановления СПИ | ЭП постановления СПИ вынесенного в электронном виде, элемента «ResolutionBase» в формате pkcs#7
     * - minOccurs: 0
     * @var string
     */
    public $SignatureResolutionBase;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: ИП | Содержит основные сведения об исполнительном производстве и должнике
     * @var \StructType\IP
     */
    public $IP;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения о должнике, указанные в постановлении СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ProcDoc
     * @uses ProcDoc::setInternalKey()
     * @uses ProcDoc::setDocDate()
     * @uses ProcDoc::setSPI()
     * @uses ProcDoc::setSPIFio()
     * @uses ProcDoc::setSPITel()
     * @uses ProcDoc::setSPIPost()
     * @uses ProcDoc::setDocNum()
     * @uses ProcDoc::setBarcode()
     * @uses ProcDoc::setDocType()
     * @uses ProcDoc::setSum()
     * @uses ProcDoc::setReason()
     * @uses ProcDoc::setArticle()
     * @uses ProcDoc::setPoint()
     * @uses ProcDoc::setPart()
     * @uses ProcDoc::setNewOspCode()
     * @uses ProcDoc::setBeginDate()
     * @uses ProcDoc::setEndDate()
     * @uses ProcDoc::setResolutionBase()
     * @uses ProcDoc::setSignatureResolutionBase()
     * @uses ProcDoc::setIP()
     * @uses ProcDoc::setData()
     * @uses ProcDoc::setSignDateTime()
     * @uses ProcDoc::setSignature()
     * @uses ProcDoc::setId()
     * @param int $internalKey
     * @param string $docDate
     * @param int $sPI
     * @param string $sPIFio
     * @param string $sPITel
     * @param string $sPIPost
     * @param string $docNum
     * @param string $barcode
     * @param string $docType
     * @param float $sum
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $part
     * @param string $newOspCode
     * @param string $beginDate
     * @param string $endDate
     * @param string $resolutionBase
     * @param string $signatureResolutionBase
     * @param \StructType\IP $iP
     * @param \StructType\Data[] $data
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $docDate = null, $sPI = null, $sPIFio = null, $sPITel = null, $sPIPost = null, $docNum = null, $barcode = null, $docType = null, $sum = null, $reason = null, $article = null, $point = null, $part = null, $newOspCode = null, $beginDate = null, $endDate = null, $resolutionBase = null, $signatureResolutionBase = null, \StructType\IP $iP = null, array $data = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setDocNum($docNum)
            ->setBarcode($barcode)
            ->setDocType($docType)
            ->setSum($sum)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setPart($part)
            ->setNewOspCode($newOspCode)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setResolutionBase($resolutionBase)
            ->setSignatureResolutionBase($signatureResolutionBase)
            ->setIP($iP)
            ->setData($data)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\ProcDoc
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\ProcDoc
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \StructType\ProcDoc
     */
    public function setSPI($sPI = null)
    {
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\ProcDoc
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \StructType\ProcDoc
     */
    public function setSPITel($sPITel = null)
    {
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\ProcDoc
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \StructType\ProcDoc
     */
    public function setDocNum($docNum = null)
    {
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\ProcDoc
     */
    public function setBarcode($barcode = null)
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\ProcDoc
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get Sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->Sum;
    }
    /**
     * Set Sum value
     * @param float $sum
     * @return \StructType\ProcDoc
     */
    public function setSum($sum = null)
    {
        $this->Sum = $sum;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\ProcDoc
     */
    public function setReason($reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \StructType\ProcDoc
     */
    public function setArticle($article = null)
    {
        $this->Article = $article;
        return $this;
    }
    /**
     * Get Point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @param string $point
     * @return \StructType\ProcDoc
     */
    public function setPoint($point = null)
    {
        $this->Point = $point;
        return $this;
    }
    /**
     * Get Part value
     * @return string|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * Set Part value
     * @param string $part
     * @return \StructType\ProcDoc
     */
    public function setPart($part = null)
    {
        $this->Part = $part;
        return $this;
    }
    /**
     * Get NewOspCode value
     * @return string|null
     */
    public function getNewOspCode()
    {
        return $this->NewOspCode;
    }
    /**
     * Set NewOspCode value
     * @param string $newOspCode
     * @return \StructType\ProcDoc
     */
    public function setNewOspCode($newOspCode = null)
    {
        $this->NewOspCode = $newOspCode;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\ProcDoc
     */
    public function setBeginDate($beginDate = null)
    {
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ProcDoc
     */
    public function setEndDate($endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ResolutionBase value
     * @return string|null
     */
    public function getResolutionBase()
    {
        return $this->ResolutionBase;
    }
    /**
     * Set ResolutionBase value
     * @param string $resolutionBase
     * @return \StructType\ProcDoc
     */
    public function setResolutionBase($resolutionBase = null)
    {
        $this->ResolutionBase = $resolutionBase;
        return $this;
    }
    /**
     * Get SignatureResolutionBase value
     * @return string|null
     */
    public function getSignatureResolutionBase()
    {
        return $this->SignatureResolutionBase;
    }
    /**
     * Set SignatureResolutionBase value
     * @param string $signatureResolutionBase
     * @return \StructType\ProcDoc
     */
    public function setSignatureResolutionBase($signatureResolutionBase = null)
    {
        $this->SignatureResolutionBase = $signatureResolutionBase;
        return $this;
    }
    /**
     * Get IP value
     * @return \StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \StructType\IP $iP
     * @return \StructType\ProcDoc
     */
    public function setIP(\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\ProcDoc
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\ProcDoc
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\ProcDoc
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\ProcDoc
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\ProcDoc
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ProcDoc
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcDoc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
