<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintFormDocumentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Печатная форма документа в формате принудительного исполнения в электронном виде | Используется для передачи печатной формы
 * юридически значимых документов в соответствующем формате. Тип данных позволяет передавать печатную форму в двоичной форме, а также
 * подпись в формате PKCS#7.
 * @subpackage Structs
 */
class PrintFormDocumentType extends AbstractStructBase
{
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Данные печатной формы документа
     * - minOccurs: 1
     * @var string
     */
    public $Content;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - documentation: MIME-формат документа | MIME-тип данных | MIME-тип данных
     * - minOccurs: 1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $ContentType;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование
     * объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DigitalSignature
     * Meta informations extracted from the WSDL
     * - documentation: ЭП печатной формы документа | Подпись печатной формы документа в формате PKCS#7 detached.
     * @var string
     */
    public $DigitalSignature;
    /**
     * Constructor method for PrintFormDocumentType
     * @uses PrintFormDocumentType::setContent()
     * @uses PrintFormDocumentType::setContentType()
     * @uses PrintFormDocumentType::setDocType()
     * @uses PrintFormDocumentType::setDocNumber()
     * @uses PrintFormDocumentType::setDocDate()
     * @uses PrintFormDocumentType::setDigitalSignature()
     * @param string $content
     * @param string $contentType
     * @param string $docType
     * @param string $docNumber
     * @param string $docDate
     * @param string $digitalSignature
     */
    public function __construct($content = null, $contentType = null, $docType = null, $docNumber = null, $docDate = null, $digitalSignature = null)
    {
        $this
            ->setContent($content)
            ->setContentType($contentType)
            ->setDocType($docType)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDigitalSignature($digitalSignature);
    }
    /**
     * Get Content value
     * @return string
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \StructType\PrintFormDocumentType
     */
    public function setContent($content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\PrintFormDocumentType
     */
    public function setContentType($contentType = null)
    {
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\PrintFormDocumentType
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\PrintFormDocumentType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\PrintFormDocumentType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DigitalSignature value
     * @return string|null
     */
    public function getDigitalSignature()
    {
        return $this->DigitalSignature;
    }
    /**
     * Set DigitalSignature value
     * @param string $digitalSignature
     * @return \StructType\PrintFormDocumentType
     */
    public function setDigitalSignature($digitalSignature = null)
    {
        $this->DigitalSignature = $digitalSignature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintFormDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
