<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PievFormatVersion StructType
 * Meta informations extracted from the WSDL
 * - documentation: Версии форматов ПИЭВ
 * @subpackage Structs
 */
class PievFormatVersion extends AbstractStructBase
{
    /**
     * The formatName
     * Meta informations extracted from the WSDL
     * - documentation: Формат представления | Наименование объекта NCORE
     * - minOccurs: 1
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $formatName;
    /**
     * The namespaceName
     * Meta informations extracted from the WSDL
     * - documentation: Пространство имен | Строка длиной от 1 до 1000 символов
     * - minOccurs: 1
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $namespaceName;
    /**
     * The xsdSchema
     * Meta informations extracted from the WSDL
     * - documentation: XSD-схема | Массив произвольных данных (бинарный)
     * - minOccurs: 0
     * @var string
     */
    public $xsdSchema;
    /**
     * The xsltTemplate
     * Meta informations extracted from the WSDL
     * - documentation: Шаблон xslt-преобразования | Массив произвольных данных (бинарный)
     * - minOccurs: 0
     * @var string
     */
    public $xsltTemplate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for PievFormatVersion
     * @uses PievFormatVersion::setFormatName()
     * @uses PievFormatVersion::setNamespaceName()
     * @uses PievFormatVersion::setXsdSchema()
     * @uses PievFormatVersion::setXsltTemplate()
     * @uses PievFormatVersion::setEndDate()
     * @param string $formatName
     * @param string $namespaceName
     * @param string $xsdSchema
     * @param string $xsltTemplate
     * @param string $endDate
     */
    public function __construct($formatName = null, $namespaceName = null, $xsdSchema = null, $xsltTemplate = null, $endDate = null)
    {
        $this
            ->setFormatName($formatName)
            ->setNamespaceName($namespaceName)
            ->setXsdSchema($xsdSchema)
            ->setXsltTemplate($xsltTemplate)
            ->setEndDate($endDate);
    }
    /**
     * Get formatName value
     * @return string
     */
    public function getFormatName()
    {
        return $this->formatName;
    }
    /**
     * Set formatName value
     * @param string $formatName
     * @return \StructType\PievFormatVersion
     */
    public function setFormatName($formatName = null)
    {
        $this->formatName = $formatName;
        return $this;
    }
    /**
     * Get namespaceName value
     * @return string
     */
    public function getNamespaceName()
    {
        return $this->namespaceName;
    }
    /**
     * Set namespaceName value
     * @param string $namespaceName
     * @return \StructType\PievFormatVersion
     */
    public function setNamespaceName($namespaceName = null)
    {
        $this->namespaceName = $namespaceName;
        return $this;
    }
    /**
     * Get xsdSchema value
     * @return string|null
     */
    public function getXsdSchema()
    {
        return $this->xsdSchema;
    }
    /**
     * Set xsdSchema value
     * @param string $xsdSchema
     * @return \StructType\PievFormatVersion
     */
    public function setXsdSchema($xsdSchema = null)
    {
        $this->xsdSchema = $xsdSchema;
        return $this;
    }
    /**
     * Get xsltTemplate value
     * @return string|null
     */
    public function getXsltTemplate()
    {
        return $this->xsltTemplate;
    }
    /**
     * Set xsltTemplate value
     * @param string $xsltTemplate
     * @return \StructType\PievFormatVersion
     */
    public function setXsltTemplate($xsltTemplate = null)
    {
        $this->xsltTemplate = $xsltTemplate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\PievFormatVersion
     */
    public function setEndDate($endDate = null)
    {
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PievFormatVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
