<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о физическом лице от ФНС
 * @subpackage Structs
 */
class PersonDatumType extends InformationType
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН физического лица | ИНН Физического лица
     * - minOccurs: 0
     * - length: 12
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}
     * @var string
     */
    public $INN;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения физического лица | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $birthPlace;
    /**
     * The OGRNIP
     * Meta informations extracted from the WSDL
     * - documentation: ОГРНИП индивидуального предпринимателя | Основной государственный регистрационный номер индивидуального предпринимателя
     * (ОГРНИП)
     * - minOccurs: 0
     * - length: 15
     * - pattern: [0-9]{15}
     * @var string
     */
    public $OGRNIP;
    /**
     * The FNSResource
     * Meta informations extracted from the WSDL
     * - documentation: Вид ресурса - источника сведений | Вид ресурса (реестра) ФНС
     * - minOccurs: 0
     * - maxInclusive: 3
     * - minInclusive: 1
     * @var int
     */
    public $FNSResource;
    /**
     * The FIO
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия, имя, отчество физического лица
     * @var \StructType\FioType
     */
    public $FIO;
    /**
     * The FIOLat
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия, имя, отчество физического лица латиницей
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $FIOLat;
    /**
     * The gender
     * Meta informations extracted from the WSDL
     * - documentation: Пол
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The SNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС физического лица | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $SNILS;
    /**
     * Constructor method for PersonDatumType
     * @uses PersonDatumType::setINN()
     * @uses PersonDatumType::setBirthDate()
     * @uses PersonDatumType::setBirthPlace()
     * @uses PersonDatumType::setOGRNIP()
     * @uses PersonDatumType::setFNSResource()
     * @uses PersonDatumType::setFIO()
     * @uses PersonDatumType::setFIOLat()
     * @uses PersonDatumType::setGender()
     * @uses PersonDatumType::setSNILS()
     * @param string $iNN
     * @param string $birthDate
     * @param string $birthPlace
     * @param string $oGRNIP
     * @param int $fNSResource
     * @param \StructType\FioType $fIO
     * @param \StructType\FioType $fIOLat
     * @param string $gender
     * @param string $sNILS
     */
    public function __construct($iNN = null, $birthDate = null, $birthPlace = null, $oGRNIP = null, $fNSResource = null, \StructType\FioType $fIO = null, \StructType\FioType $fIOLat = null, $gender = null, $sNILS = null)
    {
        $this
            ->setINN($iNN)
            ->setBirthDate($birthDate)
            ->setBirthPlace($birthPlace)
            ->setOGRNIP($oGRNIP)
            ->setFNSResource($fNSResource)
            ->setFIO($fIO)
            ->setFIOLat($fIOLat)
            ->setGender($gender)
            ->setSNILS($sNILS);
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\PersonDatumType
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\PersonDatumType
     */
    public function setBirthDate($birthDate = null)
    {
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->birthPlace;
    }
    /**
     * Set birthPlace value
     * @param string $birthPlace
     * @return \StructType\PersonDatumType
     */
    public function setBirthPlace($birthPlace = null)
    {
        $this->birthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get OGRNIP value
     * @return string|null
     */
    public function getOGRNIP()
    {
        return $this->OGRNIP;
    }
    /**
     * Set OGRNIP value
     * @param string $oGRNIP
     * @return \StructType\PersonDatumType
     */
    public function setOGRNIP($oGRNIP = null)
    {
        $this->OGRNIP = $oGRNIP;
        return $this;
    }
    /**
     * Get FNSResource value
     * @return int|null
     */
    public function getFNSResource()
    {
        return $this->FNSResource;
    }
    /**
     * Set FNSResource value
     * @param int $fNSResource
     * @return \StructType\PersonDatumType
     */
    public function setFNSResource($fNSResource = null)
    {
        $this->FNSResource = $fNSResource;
        return $this;
    }
    /**
     * Get FIO value
     * @return \StructType\FioType|null
     */
    public function getFIO()
    {
        return $this->FIO;
    }
    /**
     * Set FIO value
     * @param \StructType\FioType $fIO
     * @return \StructType\PersonDatumType
     */
    public function setFIO(\StructType\FioType $fIO = null)
    {
        $this->FIO = $fIO;
        return $this;
    }
    /**
     * Get FIOLat value
     * @return \StructType\FioType|null
     */
    public function getFIOLat()
    {
        return $this->FIOLat;
    }
    /**
     * Set FIOLat value
     * @param \StructType\FioType $fIOLat
     * @return \StructType\PersonDatumType
     */
    public function setFIOLat(\StructType\FioType $fIOLat = null)
    {
        $this->FIOLat = $fIOLat;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @uses \EnumType\GenderCodeType::valueIsValid()
     * @uses \EnumType\GenderCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\PersonDatumType
     */
    public function setGender($gender = null)
    {
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get SNILS value
     * @return string|null
     */
    public function getSNILS()
    {
        return $this->SNILS;
    }
    /**
     * Set SNILS value
     * @param string $sNILS
     * @return \StructType\PersonDatumType
     */
    public function setSNILS($sNILS = null)
    {
        $this->SNILS = $sNILS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
