<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о платежах
 * @subpackage Structs
 */
class PaymentDatumType extends InformationType
{
    /**
     * The contactTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $contactTelephone;
    /**
     * The beginDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала периода | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $beginDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания периода (включительно) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $endDate;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Код валюты | Согласно справочнику кодов валют | Валюта | Код валюты по общероссийскому классификатору валют. В случае
     * отсутствия значения кода в общероссийском классификаторе валют - используется значение из Классификатора клиринговых валют.
     * - length: 3
     * - pattern: [0-9a-zA-Zа-яА-Я]{1}[0-9]{2}
     * @var string
     */
    public $currency;
    /**
     * The paymentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежей | За 2 месяца по всем номерам телефонов. Значение меньше 1 => 0.53 (53 копейки) | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paymentAmount;
    /**
     * Constructor method for PaymentDatumType
     * @uses PaymentDatumType::setContactTelephone()
     * @uses PaymentDatumType::setBeginDate()
     * @uses PaymentDatumType::setEndDate()
     * @uses PaymentDatumType::setCurrency()
     * @uses PaymentDatumType::setPaymentAmount()
     * @param string $contactTelephone
     * @param string $beginDate
     * @param string $endDate
     * @param string $currency
     * @param float $paymentAmount
     */
    public function __construct($contactTelephone = null, $beginDate = null, $endDate = null, $currency = null, $paymentAmount = null)
    {
        $this
            ->setContactTelephone($contactTelephone)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setCurrency($currency)
            ->setPaymentAmount($paymentAmount);
    }
    /**
     * Get contactTelephone value
     * @return string|null
     */
    public function getContactTelephone()
    {
        return $this->contactTelephone;
    }
    /**
     * Set contactTelephone value
     * @param string $contactTelephone
     * @return \StructType\PaymentDatumType
     */
    public function setContactTelephone($contactTelephone = null)
    {
        $this->contactTelephone = $contactTelephone;
        return $this;
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \StructType\PaymentDatumType
     */
    public function setBeginDate($beginDate = null)
    {
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\PaymentDatumType
     */
    public function setEndDate($endDate = null)
    {
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PaymentDatumType
     */
    public function setCurrency($currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get paymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }
    /**
     * Set paymentAmount value
     * @param float $paymentAmount
     * @return \StructType\PaymentDatumType
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        $this->paymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
