<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingEMailMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Исходящее сообщение ведомственной электронной почты
 * - type: tns:OutgoingEMailMessage
 * @subpackage Structs
 */
class OutgoingEMailMessage extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IncomingMessageKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения сервера МВВ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IncomingMessageKey;
    /**
     * The InReplyTo
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения почтового сервера | Идентификатор сообщения электронной почты
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $InReplyTo;
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: Получатель | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $Recipient;
    /**
     * The CC
     * Meta informations extracted from the WSDL
     * - documentation: Копия | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $CC;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - documentation: Тема | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Subject;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: Заголовки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EMailHeaderType[]
     */
    public $Header;
    /**
     * The DocumentData
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ в формате ПИЭВ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmbeddedDocumentType[]
     */
    public $DocumentData;
    /**
     * Constructor method for OutgoingEMailMessage
     * @uses OutgoingEMailMessage::setInternalKey()
     * @uses OutgoingEMailMessage::setIncomingMessageKey()
     * @uses OutgoingEMailMessage::setInReplyTo()
     * @uses OutgoingEMailMessage::setRecipient()
     * @uses OutgoingEMailMessage::setCC()
     * @uses OutgoingEMailMessage::setSubject()
     * @uses OutgoingEMailMessage::setText()
     * @uses OutgoingEMailMessage::setHeader()
     * @uses OutgoingEMailMessage::setDocumentData()
     * @param int $internalKey
     * @param int $incomingMessageKey
     * @param string $inReplyTo
     * @param string[] $recipient
     * @param string[] $cC
     * @param string $subject
     * @param string $text
     * @param \StructType\EMailHeaderType[] $header
     * @param \StructType\EmbeddedDocumentType[] $documentData
     */
    public function __construct($internalKey = null, $incomingMessageKey = null, $inReplyTo = null, array $recipient = array(), array $cC = array(), $subject = null, $text = null, array $header = array(), array $documentData = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setIncomingMessageKey($incomingMessageKey)
            ->setInReplyTo($inReplyTo)
            ->setRecipient($recipient)
            ->setCC($cC)
            ->setSubject($subject)
            ->setText($text)
            ->setHeader($header)
            ->setDocumentData($documentData);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\OutgoingEMailMessage
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IncomingMessageKey value
     * @return int|null
     */
    public function getIncomingMessageKey()
    {
        return $this->IncomingMessageKey;
    }
    /**
     * Set IncomingMessageKey value
     * @param int $incomingMessageKey
     * @return \StructType\OutgoingEMailMessage
     */
    public function setIncomingMessageKey($incomingMessageKey = null)
    {
        $this->IncomingMessageKey = $incomingMessageKey;
        return $this;
    }
    /**
     * Get InReplyTo value
     * @return string|null
     */
    public function getInReplyTo()
    {
        return $this->InReplyTo;
    }
    /**
     * Set InReplyTo value
     * @param string $inReplyTo
     * @return \StructType\OutgoingEMailMessage
     */
    public function setInReplyTo($inReplyTo = null)
    {
        $this->InReplyTo = $inReplyTo;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string[]|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @throws \InvalidArgumentException
     * @param string[] $recipient
     * @return \StructType\OutgoingEMailMessage
     */
    public function setRecipient(array $recipient = array())
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Add item to Recipient value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OutgoingEMailMessage
     */
    public function addToRecipient($item)
    {
        $this->Recipient[] = $item;
        return $this;
    }
    /**
     * Get CC value
     * @return string[]|null
     */
    public function getCC()
    {
        return $this->CC;
    }
    /**
     * Set CC value
     * @throws \InvalidArgumentException
     * @param string[] $cC
     * @return \StructType\OutgoingEMailMessage
     */
    public function setCC(array $cC = array())
    {
        $this->CC = $cC;
        return $this;
    }
    /**
     * Add item to CC value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OutgoingEMailMessage
     */
    public function addToCC($item)
    {
        $this->CC[] = $item;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\OutgoingEMailMessage
     */
    public function setSubject($subject = null)
    {
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\OutgoingEMailMessage
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Header value
     * @return \StructType\EMailHeaderType[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \StructType\EMailHeaderType[] $header
     * @return \StructType\OutgoingEMailMessage
     */
    public function setHeader(array $header = array())
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \StructType\EMailHeaderType $item
     * @return \StructType\OutgoingEMailMessage
     */
    public function addToHeader(\StructType\EMailHeaderType $item)
    {
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return \StructType\EmbeddedDocumentType[]|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @throws \InvalidArgumentException
     * @param \StructType\EmbeddedDocumentType[] $documentData
     * @return \StructType\OutgoingEMailMessage
     */
    public function setDocumentData(array $documentData = array())
    {
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Add item to DocumentData value
     * @throws \InvalidArgumentException
     * @param \StructType\EmbeddedDocumentType $item
     * @return \StructType\OutgoingEMailMessage
     */
    public function addToDocumentData(\StructType\EmbeddedDocumentType $item)
    {
        $this->DocumentData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutgoingEMailMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
