<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OspInputRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ для передачи реестров
 * - type: tns:OspInputRegistry
 * @subpackage Structs
 */
class OspInputRegistry extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocVersion
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $DocVersion;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The RegistryType
     * Meta informations extracted from the WSDL
     * - documentation: Тип передаваемого реестра
     * @var string
     */
    public $RegistryType;
    /**
     * Constructor method for OspInputRegistry
     * @uses OspInputRegistry::setInternalKey()
     * @uses OspInputRegistry::setDocDate()
     * @uses OspInputRegistry::setDocVersion()
     * @uses OspInputRegistry::setUnloadDate()
     * @uses OspInputRegistry::setOspCode()
     * @uses OspInputRegistry::setRegistryType()
     * @param int $internalKey
     * @param string $docDate
     * @param int $docVersion
     * @param string $unloadDate
     * @param string $ospCode
     * @param string $registryType
     */
    public function __construct($internalKey = null, $docDate = null, $docVersion = null, $unloadDate = null, $ospCode = null, $registryType = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setDocVersion($docVersion)
            ->setUnloadDate($unloadDate)
            ->setOspCode($ospCode)
            ->setRegistryType($registryType);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\OspInputRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\OspInputRegistry
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocVersion value
     * @return int|null
     */
    public function getDocVersion()
    {
        return $this->DocVersion;
    }
    /**
     * Set DocVersion value
     * @param int $docVersion
     * @return \StructType\OspInputRegistry
     */
    public function setDocVersion($docVersion = null)
    {
        $this->DocVersion = $docVersion;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\OspInputRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\OspInputRegistry
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get RegistryType value
     * @return string|null
     */
    public function getRegistryType()
    {
        return $this->RegistryType;
    }
    /**
     * Set RegistryType value
     * @uses \EnumType\RegistryType::valueIsValid()
     * @uses \EnumType\RegistryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registryType
     * @return \StructType\OspInputRegistry
     */
    public function setRegistryType($registryType = null)
    {
        $this->RegistryType = $registryType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OspInputRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
