<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoticeReadinessSaleSeizedProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Уведомление о готовности к реализации арестованного имущества | ЭП
 * - type: tns:NoticeReadinessSaleSeizedProperty
 * @subpackage Structs
 */
class NoticeReadinessSaleSeizedProperty extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Идентификатор уведомления о готовности к реализации арестованного имущества. | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The NoticeNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер уведомления | Номер уведомления о готовности к реализации арестованного имущества. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NoticeNum;
    /**
     * The NoticeDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата уведомления | Дата уведомления о готовности к реализации арестованного имущества. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $NoticeDate;
    /**
     * The ProcDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления | Ключ постановления судебного пристава-исполнителя о передачи арестованного имущества должника на
     * реализацию. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ProcDocId;
    /**
     * The ProcDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Электронный номер постановления | Электронный номер постановления судебного пристава-исполнителя о передачи арестованного
     * имущества должника на реализацию. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ProcDocNumber;
    /**
     * The ProcDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вынесения постановления | Дата вынесения постановления судебного пристава-исполнителя о передачи арестованного
     * имущества должника на реализацию. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ProcDocDate;
    /**
     * The NoticeReadinessSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление
     * - minOccurs: 0
     * @var string
     */
    public $NoticeReadinessSaleSeizedPropertyBase;
    /**
     * The SignatureNoticeReadinessSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП уведомления | ЭП уведомления о готовности к реализации арестованного имущества вынесенного в электронном виде, элемента
     * «NoticeReadinessSaleSeizedPropertyBase» в формате pkcs#7, в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureNoticeReadinessSaleSeizedPropertyBase;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: ИП | Содержит основные сведения об исполнительном производстве и должнике.
     * @var \StructType\IP
     */
    public $IP;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Приложенные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for NoticeReadinessSaleSeizedProperty
     * @uses NoticeReadinessSaleSeizedProperty::setInternalKey()
     * @uses NoticeReadinessSaleSeizedProperty::setNoticeNum()
     * @uses NoticeReadinessSaleSeizedProperty::setNoticeDate()
     * @uses NoticeReadinessSaleSeizedProperty::setProcDocId()
     * @uses NoticeReadinessSaleSeizedProperty::setProcDocNumber()
     * @uses NoticeReadinessSaleSeizedProperty::setProcDocDate()
     * @uses NoticeReadinessSaleSeizedProperty::setNoticeReadinessSaleSeizedPropertyBase()
     * @uses NoticeReadinessSaleSeizedProperty::setSignatureNoticeReadinessSaleSeizedPropertyBase()
     * @uses NoticeReadinessSaleSeizedProperty::setIP()
     * @uses NoticeReadinessSaleSeizedProperty::setAttachments()
     * @uses NoticeReadinessSaleSeizedProperty::setSignDateTime()
     * @uses NoticeReadinessSaleSeizedProperty::setSignature()
     * @param int $internalKey
     * @param string $noticeNum
     * @param string $noticeDate
     * @param int $procDocId
     * @param string $procDocNumber
     * @param string $procDocDate
     * @param string $noticeReadinessSaleSeizedPropertyBase
     * @param string $signatureNoticeReadinessSaleSeizedPropertyBase
     * @param \StructType\IP $iP
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $noticeNum = null, $noticeDate = null, $procDocId = null, $procDocNumber = null, $procDocDate = null, $noticeReadinessSaleSeizedPropertyBase = null, $signatureNoticeReadinessSaleSeizedPropertyBase = null, \StructType\IP $iP = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setNoticeNum($noticeNum)
            ->setNoticeDate($noticeDate)
            ->setProcDocId($procDocId)
            ->setProcDocNumber($procDocNumber)
            ->setProcDocDate($procDocDate)
            ->setNoticeReadinessSaleSeizedPropertyBase($noticeReadinessSaleSeizedPropertyBase)
            ->setSignatureNoticeReadinessSaleSeizedPropertyBase($signatureNoticeReadinessSaleSeizedPropertyBase)
            ->setIP($iP)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get NoticeNum value
     * @return string|null
     */
    public function getNoticeNum()
    {
        return $this->NoticeNum;
    }
    /**
     * Set NoticeNum value
     * @param string $noticeNum
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setNoticeNum($noticeNum = null)
    {
        $this->NoticeNum = $noticeNum;
        return $this;
    }
    /**
     * Get NoticeDate value
     * @return string|null
     */
    public function getNoticeDate()
    {
        return $this->NoticeDate;
    }
    /**
     * Set NoticeDate value
     * @param string $noticeDate
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setNoticeDate($noticeDate = null)
    {
        $this->NoticeDate = $noticeDate;
        return $this;
    }
    /**
     * Get ProcDocId value
     * @return int|null
     */
    public function getProcDocId()
    {
        return $this->ProcDocId;
    }
    /**
     * Set ProcDocId value
     * @param int $procDocId
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setProcDocId($procDocId = null)
    {
        $this->ProcDocId = $procDocId;
        return $this;
    }
    /**
     * Get ProcDocNumber value
     * @return string|null
     */
    public function getProcDocNumber()
    {
        return $this->ProcDocNumber;
    }
    /**
     * Set ProcDocNumber value
     * @param string $procDocNumber
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setProcDocNumber($procDocNumber = null)
    {
        $this->ProcDocNumber = $procDocNumber;
        return $this;
    }
    /**
     * Get ProcDocDate value
     * @return string|null
     */
    public function getProcDocDate()
    {
        return $this->ProcDocDate;
    }
    /**
     * Set ProcDocDate value
     * @param string $procDocDate
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setProcDocDate($procDocDate = null)
    {
        $this->ProcDocDate = $procDocDate;
        return $this;
    }
    /**
     * Get NoticeReadinessSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getNoticeReadinessSaleSeizedPropertyBase()
    {
        return $this->NoticeReadinessSaleSeizedPropertyBase;
    }
    /**
     * Set NoticeReadinessSaleSeizedPropertyBase value
     * @param string $noticeReadinessSaleSeizedPropertyBase
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setNoticeReadinessSaleSeizedPropertyBase($noticeReadinessSaleSeizedPropertyBase = null)
    {
        $this->NoticeReadinessSaleSeizedPropertyBase = $noticeReadinessSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get SignatureNoticeReadinessSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getSignatureNoticeReadinessSaleSeizedPropertyBase()
    {
        return $this->SignatureNoticeReadinessSaleSeizedPropertyBase;
    }
    /**
     * Set SignatureNoticeReadinessSaleSeizedPropertyBase value
     * @param string $signatureNoticeReadinessSaleSeizedPropertyBase
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setSignatureNoticeReadinessSaleSeizedPropertyBase($signatureNoticeReadinessSaleSeizedPropertyBase = null)
    {
        $this->SignatureNoticeReadinessSaleSeizedPropertyBase = $signatureNoticeReadinessSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get IP value
     * @return \StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \StructType\IP $iP
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setIP(\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NoticeReadinessSaleSeizedProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
