<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат приема сообщения
 * @subpackage Structs
 */
class MessageResult extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Статус приема пакета документов
     * @var string
     */
    public $status;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки | Код ошибки
     * - minOccurs: 0
     * @var int
     */
    public $errorCode;
    /**
     * The errorText
     * Meta informations extracted from the WSDL
     * - documentation: Текст ошибки | Текст ошибки
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 0
     * @var string
     */
    public $errorText;
    /**
     * Constructor method for MessageResult
     * @uses MessageResult::setInternalKey()
     * @uses MessageResult::setExternalKey()
     * @uses MessageResult::setStatus()
     * @uses MessageResult::setErrorCode()
     * @uses MessageResult::setErrorText()
     * @param int $internalKey
     * @param string $externalKey
     * @param string $status
     * @param int $errorCode
     * @param string $errorText
     */
    public function __construct($internalKey = null, $externalKey = null, $status = null, $errorCode = null, $errorText = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalKey($externalKey)
            ->setStatus($status)
            ->setErrorCode($errorCode)
            ->setErrorText($errorText);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\MessageResult
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \StructType\MessageResult
     */
    public function setExternalKey($externalKey = null)
    {
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StatusCode::valueIsValid()
     * @uses \EnumType\StatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\MessageResult
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\MessageResult
     */
    public function setErrorCode($errorCode = null)
    {
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->errorText;
    }
    /**
     * Set errorText value
     * @param string $errorText
     * @return \StructType\MessageResult
     */
    public function setErrorText($errorText = null)
    {
        $this->errorText = $errorText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
