<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageCollection StructType
 * Meta informations extracted from the WSDL
 * - documentation: Коллекция сообщений
 * @subpackage Structs
 */
class MessageCollection extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - documentation: Множество сообщений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Message[]
     */
    public $message;
    /**
     * Constructor method for MessageCollection
     * @uses MessageCollection::setMessage()
     * @param \StructType\Message[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get message value
     * @return \StructType\Message[]|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @throws \InvalidArgumentException
     * @param \StructType\Message[] $message
     * @return \StructType\MessageCollection
     */
    public function setMessage(array $message = array())
    {
        $this->message = $message;
        return $this;
    }
    /**
     * Add item to message value
     * @throws \InvalidArgumentException
     * @param \StructType\Message $item
     * @return \StructType\MessageCollection
     */
    public function addToMessage(\StructType\Message $item)
    {
        $this->message[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
