<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManagementDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений ManagementDataType "Должностные лица" | Содержит данные о должностных лицах (руководителях) организации
 * @subpackage Structs
 */
class ManagementDataType extends InformationType
{
    /**
     * The ManagerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должностного лица | Тип должностного лица | NSI_MVV_Manager
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $ManagerType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: ФИО
     * @var \StructType\FioType
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес проживания руководителя | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for ManagementDataType
     * @uses ManagementDataType::setManagerType()
     * @uses ManagementDataType::setName()
     * @uses ManagementDataType::setAddress()
     * @uses ManagementDataType::setTelephoneNumber()
     * @param string $managerType
     * @param \StructType\FioType $name
     * @param string $address
     * @param string $telephoneNumber
     */
    public function __construct($managerType = null, \StructType\FioType $name = null, $address = null, $telephoneNumber = null)
    {
        $this
            ->setManagerType($managerType)
            ->setName($name)
            ->setAddress($address)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get ManagerType value
     * @return string|null
     */
    public function getManagerType()
    {
        return $this->ManagerType;
    }
    /**
     * Set ManagerType value
     * @param string $managerType
     * @return \StructType\ManagementDataType
     */
    public function setManagerType($managerType = null)
    {
        $this->ManagerType = $managerType;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\FioType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\FioType $name
     * @return \StructType\ManagementDataType
     */
    public function setName(\StructType\FioType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ManagementDataType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\ManagementDataType
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManagementDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
