<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MachineDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о машине
 * @subpackage Structs
 */
class MachineDatumType extends InformationType
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Тип машины
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование машины (агрегата) | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The Kind
     * Meta informations extracted from the WSDL
     * - documentation: Вид машины (агрегата)
     * - minOccurs: 0
     * @var string
     */
    public $Kind;
    /**
     * The Subkind
     * Meta informations extracted from the WSDL
     * - documentation: Подвид машины (подвид)
     * - minOccurs: 0
     * @var string
     */
    public $Subkind;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Марка машины | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BrandName;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - documentation: Категория машины | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Category;
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - documentation: Модель | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ModelName;
    /**
     * The MadeYear
     * Meta informations extracted from the WSDL
     * - documentation: Год выпуска | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $MadeYear;
    /**
     * The Manufacturer
     * Meta informations extracted from the WSDL
     * - documentation: Предприятие-изготовитель | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Manufacturer;
    /**
     * The VIN
     * Meta informations extracted from the WSDL
     * - documentation: VIN | Код начисления УНИФО
     * - minOccurs: 0
     * - length: 17
     * @var string
     */
    public $VIN;
    /**
     * The ChassisNumber
     * Meta informations extracted from the WSDL
     * - documentation: Заводской № машины (рамы) | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ChassisNumber;
    /**
     * The OKP
     * Meta informations extracted from the WSDL
     * - documentation: ОКП | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $OKP;
    /**
     * The EngineKind
     * Meta informations extracted from the WSDL
     * - documentation: Вид двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $EngineKind;
    /**
     * The EngineNumber
     * Meta informations extracted from the WSDL
     * - documentation: № двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $EngineNumber;
    /**
     * The EngineVolume
     * Meta informations extracted from the WSDL
     * - documentation: Рабочий объём двигателя, см3 | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EngineVolume;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, киловатт | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, лошадиных сил | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * The TransmissionNumber
     * Meta informations extracted from the WSDL
     * - documentation: № КПП | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $TransmissionNumber;
    /**
     * The DrivingAxleNumber
     * Meta informations extracted from the WSDL
     * - documentation: № основного ведущего моста | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $DrivingAxleNumber;
    /**
     * The OtherMfgNumber
     * Meta informations extracted from the WSDL
     * - documentation: Прочие заводские номера | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $OtherMfgNumber;
    /**
     * The DesignWeight
     * Meta informations extracted from the WSDL
     * - documentation: Конструкционная масса, кг | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $DesignWeight;
    /**
     * The DesignSpeed
     * Meta informations extracted from the WSDL
     * - documentation: Максимальная конструктивная скорость, км/ч | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $DesignSpeed;
    /**
     * The Colour
     * Meta informations extracted from the WSDL
     * - documentation: Цвет | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Colour;
    /**
     * The RequireDoc
     * Meta informations extracted from the WSDL
     * - documentation: Документ подтверждения соответствия
     * - minOccurs: 0
     * @var string
     */
    public $RequireDoc;
    /**
     * The RequireDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа подтверждения соответствия | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RequireDocNumber;
    /**
     * The RequireDocIssuer
     * Meta informations extracted from the WSDL
     * - documentation: Орган выдавший документ подтверждения соответствия | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $RequireDocIssuer;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Особые отметки | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Notes;
    /**
     * The HasWritedOff
     * Meta informations extracted from the WSDL
     * - documentation: Списана | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasWritedOff;
    /**
     * The HasLost
     * Meta informations extracted from the WSDL
     * - documentation: Утеряна | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasLost;
    /**
     * The HasStealed
     * Meta informations extracted from the WSDL
     * - documentation: Похищена | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasStealed;
    /**
     * The HasRestricted
     * Meta informations extracted from the WSDL
     * - documentation: Ограничение | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasRestricted;
    /**
     * Constructor method for MachineDatumType
     * @uses MachineDatumType::setType()
     * @uses MachineDatumType::setName()
     * @uses MachineDatumType::setKind()
     * @uses MachineDatumType::setSubkind()
     * @uses MachineDatumType::setBrandName()
     * @uses MachineDatumType::setCategory()
     * @uses MachineDatumType::setModelName()
     * @uses MachineDatumType::setMadeYear()
     * @uses MachineDatumType::setManufacturer()
     * @uses MachineDatumType::setVIN()
     * @uses MachineDatumType::setChassisNumber()
     * @uses MachineDatumType::setOKP()
     * @uses MachineDatumType::setEngineKind()
     * @uses MachineDatumType::setEngineNumber()
     * @uses MachineDatumType::setEngineVolume()
     * @uses MachineDatumType::setEnginePowerKWh()
     * @uses MachineDatumType::setEnginePowerHp()
     * @uses MachineDatumType::setTransmissionNumber()
     * @uses MachineDatumType::setDrivingAxleNumber()
     * @uses MachineDatumType::setOtherMfgNumber()
     * @uses MachineDatumType::setDesignWeight()
     * @uses MachineDatumType::setDesignSpeed()
     * @uses MachineDatumType::setColour()
     * @uses MachineDatumType::setRequireDoc()
     * @uses MachineDatumType::setRequireDocNumber()
     * @uses MachineDatumType::setRequireDocIssuer()
     * @uses MachineDatumType::setNotes()
     * @uses MachineDatumType::setHasWritedOff()
     * @uses MachineDatumType::setHasLost()
     * @uses MachineDatumType::setHasStealed()
     * @uses MachineDatumType::setHasRestricted()
     * @param string $type
     * @param string $name
     * @param string $kind
     * @param string $subkind
     * @param string $brandName
     * @param string $category
     * @param string $modelName
     * @param string $madeYear
     * @param string $manufacturer
     * @param string $vIN
     * @param string $chassisNumber
     * @param string $oKP
     * @param string $engineKind
     * @param string $engineNumber
     * @param float $engineVolume
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     * @param string $transmissionNumber
     * @param string $drivingAxleNumber
     * @param string $otherMfgNumber
     * @param int $designWeight
     * @param int $designSpeed
     * @param string $colour
     * @param string $requireDoc
     * @param string $requireDocNumber
     * @param string $requireDocIssuer
     * @param string $notes
     * @param bool $hasWritedOff
     * @param bool $hasLost
     * @param bool $hasStealed
     * @param bool $hasRestricted
     */
    public function __construct($type = null, $name = null, $kind = null, $subkind = null, $brandName = null, $category = null, $modelName = null, $madeYear = null, $manufacturer = null, $vIN = null, $chassisNumber = null, $oKP = null, $engineKind = null, $engineNumber = null, $engineVolume = null, $enginePowerKWh = null, $enginePowerHp = null, $transmissionNumber = null, $drivingAxleNumber = null, $otherMfgNumber = null, $designWeight = null, $designSpeed = null, $colour = null, $requireDoc = null, $requireDocNumber = null, $requireDocIssuer = null, $notes = null, $hasWritedOff = null, $hasLost = null, $hasStealed = null, $hasRestricted = null)
    {
        $this
            ->setType($type)
            ->setName($name)
            ->setKind($kind)
            ->setSubkind($subkind)
            ->setBrandName($brandName)
            ->setCategory($category)
            ->setModelName($modelName)
            ->setMadeYear($madeYear)
            ->setManufacturer($manufacturer)
            ->setVIN($vIN)
            ->setChassisNumber($chassisNumber)
            ->setOKP($oKP)
            ->setEngineKind($engineKind)
            ->setEngineNumber($engineNumber)
            ->setEngineVolume($engineVolume)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp)
            ->setTransmissionNumber($transmissionNumber)
            ->setDrivingAxleNumber($drivingAxleNumber)
            ->setOtherMfgNumber($otherMfgNumber)
            ->setDesignWeight($designWeight)
            ->setDesignSpeed($designSpeed)
            ->setColour($colour)
            ->setRequireDoc($requireDoc)
            ->setRequireDocNumber($requireDocNumber)
            ->setRequireDocIssuer($requireDocIssuer)
            ->setNotes($notes)
            ->setHasWritedOff($hasWritedOff)
            ->setHasLost($hasLost)
            ->setHasStealed($hasStealed)
            ->setHasRestricted($hasRestricted);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\MachineType::valueIsValid()
     * @uses \EnumType\MachineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\MachineDatumType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\MachineDatumType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Kind value
     * @return string|null
     */
    public function getKind()
    {
        return $this->Kind;
    }
    /**
     * Set Kind value
     * @uses \EnumType\MachineKind::valueIsValid()
     * @uses \EnumType\MachineKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return \StructType\MachineDatumType
     */
    public function setKind($kind = null)
    {
        $this->Kind = $kind;
        return $this;
    }
    /**
     * Get Subkind value
     * @return string|null
     */
    public function getSubkind()
    {
        return $this->Subkind;
    }
    /**
     * Set Subkind value
     * @uses \EnumType\MachineSubkind::valueIsValid()
     * @uses \EnumType\MachineSubkind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subkind
     * @return \StructType\MachineDatumType
     */
    public function setSubkind($subkind = null)
    {
        $this->Subkind = $subkind;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\MachineDatumType
     */
    public function setBrandName($brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\MachineDatumType
     */
    public function setCategory($category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \StructType\MachineDatumType
     */
    public function setModelName($modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get MadeYear value
     * @return string|null
     */
    public function getMadeYear()
    {
        return $this->MadeYear;
    }
    /**
     * Set MadeYear value
     * @param string $madeYear
     * @return \StructType\MachineDatumType
     */
    public function setMadeYear($madeYear = null)
    {
        $this->MadeYear = $madeYear;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param string $manufacturer
     * @return \StructType\MachineDatumType
     */
    public function setManufacturer($manufacturer = null)
    {
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get VIN value
     * @return string|null
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\MachineDatumType
     */
    public function setVIN($vIN = null)
    {
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get ChassisNumber value
     * @return string|null
     */
    public function getChassisNumber()
    {
        return $this->ChassisNumber;
    }
    /**
     * Set ChassisNumber value
     * @param string $chassisNumber
     * @return \StructType\MachineDatumType
     */
    public function setChassisNumber($chassisNumber = null)
    {
        $this->ChassisNumber = $chassisNumber;
        return $this;
    }
    /**
     * Get OKP value
     * @return string|null
     */
    public function getOKP()
    {
        return $this->OKP;
    }
    /**
     * Set OKP value
     * @param string $oKP
     * @return \StructType\MachineDatumType
     */
    public function setOKP($oKP = null)
    {
        $this->OKP = $oKP;
        return $this;
    }
    /**
     * Get EngineKind value
     * @return string|null
     */
    public function getEngineKind()
    {
        return $this->EngineKind;
    }
    /**
     * Set EngineKind value
     * @param string $engineKind
     * @return \StructType\MachineDatumType
     */
    public function setEngineKind($engineKind = null)
    {
        $this->EngineKind = $engineKind;
        return $this;
    }
    /**
     * Get EngineNumber value
     * @return string|null
     */
    public function getEngineNumber()
    {
        return $this->EngineNumber;
    }
    /**
     * Set EngineNumber value
     * @param string $engineNumber
     * @return \StructType\MachineDatumType
     */
    public function setEngineNumber($engineNumber = null)
    {
        $this->EngineNumber = $engineNumber;
        return $this;
    }
    /**
     * Get EngineVolume value
     * @return float|null
     */
    public function getEngineVolume()
    {
        return $this->EngineVolume;
    }
    /**
     * Set EngineVolume value
     * @param float $engineVolume
     * @return \StructType\MachineDatumType
     */
    public function setEngineVolume($engineVolume = null)
    {
        $this->EngineVolume = $engineVolume;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \StructType\MachineDatumType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \StructType\MachineDatumType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Get TransmissionNumber value
     * @return string|null
     */
    public function getTransmissionNumber()
    {
        return $this->TransmissionNumber;
    }
    /**
     * Set TransmissionNumber value
     * @param string $transmissionNumber
     * @return \StructType\MachineDatumType
     */
    public function setTransmissionNumber($transmissionNumber = null)
    {
        $this->TransmissionNumber = $transmissionNumber;
        return $this;
    }
    /**
     * Get DrivingAxleNumber value
     * @return string|null
     */
    public function getDrivingAxleNumber()
    {
        return $this->DrivingAxleNumber;
    }
    /**
     * Set DrivingAxleNumber value
     * @param string $drivingAxleNumber
     * @return \StructType\MachineDatumType
     */
    public function setDrivingAxleNumber($drivingAxleNumber = null)
    {
        $this->DrivingAxleNumber = $drivingAxleNumber;
        return $this;
    }
    /**
     * Get OtherMfgNumber value
     * @return string|null
     */
    public function getOtherMfgNumber()
    {
        return $this->OtherMfgNumber;
    }
    /**
     * Set OtherMfgNumber value
     * @param string $otherMfgNumber
     * @return \StructType\MachineDatumType
     */
    public function setOtherMfgNumber($otherMfgNumber = null)
    {
        $this->OtherMfgNumber = $otherMfgNumber;
        return $this;
    }
    /**
     * Get DesignWeight value
     * @return int|null
     */
    public function getDesignWeight()
    {
        return $this->DesignWeight;
    }
    /**
     * Set DesignWeight value
     * @param int $designWeight
     * @return \StructType\MachineDatumType
     */
    public function setDesignWeight($designWeight = null)
    {
        $this->DesignWeight = $designWeight;
        return $this;
    }
    /**
     * Get DesignSpeed value
     * @return int|null
     */
    public function getDesignSpeed()
    {
        return $this->DesignSpeed;
    }
    /**
     * Set DesignSpeed value
     * @param int $designSpeed
     * @return \StructType\MachineDatumType
     */
    public function setDesignSpeed($designSpeed = null)
    {
        $this->DesignSpeed = $designSpeed;
        return $this;
    }
    /**
     * Get Colour value
     * @return string|null
     */
    public function getColour()
    {
        return $this->Colour;
    }
    /**
     * Set Colour value
     * @param string $colour
     * @return \StructType\MachineDatumType
     */
    public function setColour($colour = null)
    {
        $this->Colour = $colour;
        return $this;
    }
    /**
     * Get RequireDoc value
     * @return string|null
     */
    public function getRequireDoc()
    {
        return $this->RequireDoc;
    }
    /**
     * Set RequireDoc value
     * @uses \EnumType\RequirementsDocType::valueIsValid()
     * @uses \EnumType\RequirementsDocType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requireDoc
     * @return \StructType\MachineDatumType
     */
    public function setRequireDoc($requireDoc = null)
    {
        $this->RequireDoc = $requireDoc;
        return $this;
    }
    /**
     * Get RequireDocNumber value
     * @return string|null
     */
    public function getRequireDocNumber()
    {
        return $this->RequireDocNumber;
    }
    /**
     * Set RequireDocNumber value
     * @param string $requireDocNumber
     * @return \StructType\MachineDatumType
     */
    public function setRequireDocNumber($requireDocNumber = null)
    {
        $this->RequireDocNumber = $requireDocNumber;
        return $this;
    }
    /**
     * Get RequireDocIssuer value
     * @return string|null
     */
    public function getRequireDocIssuer()
    {
        return $this->RequireDocIssuer;
    }
    /**
     * Set RequireDocIssuer value
     * @param string $requireDocIssuer
     * @return \StructType\MachineDatumType
     */
    public function setRequireDocIssuer($requireDocIssuer = null)
    {
        $this->RequireDocIssuer = $requireDocIssuer;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\MachineDatumType
     */
    public function setNotes($notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get HasWritedOff value
     * @return bool|null
     */
    public function getHasWritedOff()
    {
        return $this->HasWritedOff;
    }
    /**
     * Set HasWritedOff value
     * @param bool $hasWritedOff
     * @return \StructType\MachineDatumType
     */
    public function setHasWritedOff($hasWritedOff = null)
    {
        $this->HasWritedOff = $hasWritedOff;
        return $this;
    }
    /**
     * Get HasLost value
     * @return bool|null
     */
    public function getHasLost()
    {
        return $this->HasLost;
    }
    /**
     * Set HasLost value
     * @param bool $hasLost
     * @return \StructType\MachineDatumType
     */
    public function setHasLost($hasLost = null)
    {
        $this->HasLost = $hasLost;
        return $this;
    }
    /**
     * Get HasStealed value
     * @return bool|null
     */
    public function getHasStealed()
    {
        return $this->HasStealed;
    }
    /**
     * Set HasStealed value
     * @param bool $hasStealed
     * @return \StructType\MachineDatumType
     */
    public function setHasStealed($hasStealed = null)
    {
        $this->HasStealed = $hasStealed;
        return $this;
    }
    /**
     * Get HasRestricted value
     * @return bool|null
     */
    public function getHasRestricted()
    {
        return $this->HasRestricted;
    }
    /**
     * Set HasRestricted value
     * @param bool $hasRestricted
     * @return \StructType\MachineDatumType
     */
    public function setHasRestricted($hasRestricted = null)
    {
        $this->HasRestricted = $hasRestricted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MachineDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
