<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupTableData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные справочника | Записи данных одного справочника | Данные справочника
 * @subpackage Structs
 */
class LookupTableData extends AbstractStructBase
{
    /**
     * The caption
     * Meta informations extracted from the WSDL
     * - documentation: Заголовок справочника | Заголовок
     * - use: required
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $caption;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The lookupTable
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * - minOccurs: 0
     * @var string
     */
    public $lookupTable;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительное условие | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $filter;
    /**
     * The osp
     * Meta informations extracted from the WSDL
     * - documentation: Отдел судебных приставов
     * @var \StructType\OspProperty
     */
    public $osp;
    /**
     * The idDocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа, удостоверяющего личность
     * @var \StructType\IdDocTypeProperty
     */
    public $idDocType;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Валюта
     * @var \StructType\CurrencyProperty
     */
    public $currency;
    /**
     * The pievFormat
     * Meta informations extracted from the WSDL
     * - documentation: Версии форматов ПИЭВ
     * @var \StructType\PievFormatVersion
     */
    public $pievFormat;
    /**
     * Constructor method for LookupTableData
     * @uses LookupTableData::setCaption()
     * @uses LookupTableData::setAny()
     * @uses LookupTableData::setLookupTable()
     * @uses LookupTableData::setFilter()
     * @uses LookupTableData::setOsp()
     * @uses LookupTableData::setIdDocType()
     * @uses LookupTableData::setCurrency()
     * @uses LookupTableData::setPievFormat()
     * @param string $caption
     * @param \DOMDocument $any
     * @param string $lookupTable
     * @param string $filter
     * @param \StructType\OspProperty $osp
     * @param \StructType\IdDocTypeProperty $idDocType
     * @param \StructType\CurrencyProperty $currency
     * @param \StructType\PievFormatVersion $pievFormat
     */
    public function __construct($caption = null, \DOMDocument $any = null, $lookupTable = null, $filter = null, \StructType\OspProperty $osp = null, \StructType\IdDocTypeProperty $idDocType = null, \StructType\CurrencyProperty $currency = null, \StructType\PievFormatVersion $pievFormat = null)
    {
        $this
            ->setCaption($caption)
            ->setAny($any)
            ->setLookupTable($lookupTable)
            ->setFilter($filter)
            ->setOsp($osp)
            ->setIdDocType($idDocType)
            ->setCurrency($currency)
            ->setPievFormat($pievFormat);
    }
    /**
     * Get caption value
     * @return string
     */
    public function getCaption()
    {
        return $this->caption;
    }
    /**
     * Set caption value
     * @param string $caption
     * @return \StructType\LookupTableData
     */
    public function setCaption($caption = null)
    {
        $this->caption = $caption;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\LookupTableData::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\LookupTableData
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get lookupTable value
     * @return string|null
     */
    public function getLookupTable()
    {
        return $this->lookupTable;
    }
    /**
     * Set lookupTable value
     * @uses \EnumType\LookupTableType::valueIsValid()
     * @uses \EnumType\LookupTableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lookupTable
     * @return \StructType\LookupTableData
     */
    public function setLookupTable($lookupTable = null)
    {
        $this->lookupTable = $lookupTable;
        return $this;
    }
    /**
     * Get filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param string $filter
     * @return \StructType\LookupTableData
     */
    public function setFilter($filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get osp value
     * @return \StructType\OspProperty|null
     */
    public function getOsp()
    {
        return $this->osp;
    }
    /**
     * Set osp value
     * @param \StructType\OspProperty $osp
     * @return \StructType\LookupTableData
     */
    public function setOsp(\StructType\OspProperty $osp = null)
    {
        $this->osp = $osp;
        return $this;
    }
    /**
     * Get idDocType value
     * @return \StructType\IdDocTypeProperty|null
     */
    public function getIdDocType()
    {
        return $this->idDocType;
    }
    /**
     * Set idDocType value
     * @param \StructType\IdDocTypeProperty $idDocType
     * @return \StructType\LookupTableData
     */
    public function setIdDocType(\StructType\IdDocTypeProperty $idDocType = null)
    {
        $this->idDocType = $idDocType;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\CurrencyProperty|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\CurrencyProperty $currency
     * @return \StructType\LookupTableData
     */
    public function setCurrency(\StructType\CurrencyProperty $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get pievFormat value
     * @return \StructType\PievFormatVersion|null
     */
    public function getPievFormat()
    {
        return $this->pievFormat;
    }
    /**
     * Set pievFormat value
     * @param \StructType\PievFormatVersion $pievFormat
     * @return \StructType\LookupTableData
     */
    public function setPievFormat(\StructType\PievFormatVersion $pievFormat = null)
    {
        $this->pievFormat = $pievFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LookupTableData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
