<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о лицензии
 * @subpackage Structs
 */
class LicenseDatumType extends InformationType
{
    /**
     * The licenseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер лицензии | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $licenseNumber;
    /**
     * The licenseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $licenseDate;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDate;
    /**
     * The suspendDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата приостановления действия лицензии или дата аннулирования лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $suspendDate;
    /**
     * The finDateResumed
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDateResumed;
    /**
     * The licenseActivities
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о видах деятельности на которые выдана лицензия
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LicenseActivityType[]
     */
    public $licenseActivities;
    /**
     * The stateId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния лицензии | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $stateId;
    /**
     * The stateName
     * Meta informations extracted from the WSDL
     * - documentation: Название состояния лицензии | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $stateName;
    /**
     * The recipientName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование получателя | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $recipientName;
    /**
     * The recipientAddress
     * Meta informations extracted from the WSDL
     * - documentation: Местонахождения получателя | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $recipientAddress;
    /**
     * The operationAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места эксплуатации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $operationAddress;
    /**
     * The authorizedPersonFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО уполномоченного лица | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $authorizedPersonFio;
    /**
     * The authorizedPersonPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность уполномоченного лица | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $authorizedPersonPost;
    /**
     * The appendix
     * Meta informations extracted from the WSDL
     * - documentation: Приложение | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $appendix;
    /**
     * Constructor method for LicenseDatumType
     * @uses LicenseDatumType::setLicenseNumber()
     * @uses LicenseDatumType::setLicenseDate()
     * @uses LicenseDatumType::setStartDate()
     * @uses LicenseDatumType::setFinDate()
     * @uses LicenseDatumType::setSuspendDate()
     * @uses LicenseDatumType::setFinDateResumed()
     * @uses LicenseDatumType::setLicenseActivities()
     * @uses LicenseDatumType::setStateId()
     * @uses LicenseDatumType::setStateName()
     * @uses LicenseDatumType::setRecipientName()
     * @uses LicenseDatumType::setRecipientAddress()
     * @uses LicenseDatumType::setOperationAddress()
     * @uses LicenseDatumType::setAuthorizedPersonFio()
     * @uses LicenseDatumType::setAuthorizedPersonPost()
     * @uses LicenseDatumType::setAppendix()
     * @param string $licenseNumber
     * @param string $licenseDate
     * @param string $startDate
     * @param string $finDate
     * @param string $suspendDate
     * @param string $finDateResumed
     * @param \StructType\LicenseActivityType[] $licenseActivities
     * @param int $stateId
     * @param string $stateName
     * @param string $recipientName
     * @param string $recipientAddress
     * @param string $operationAddress
     * @param string $authorizedPersonFio
     * @param string $authorizedPersonPost
     * @param string $appendix
     */
    public function __construct($licenseNumber = null, $licenseDate = null, $startDate = null, $finDate = null, $suspendDate = null, $finDateResumed = null, array $licenseActivities = array(), $stateId = null, $stateName = null, $recipientName = null, $recipientAddress = null, $operationAddress = null, $authorizedPersonFio = null, $authorizedPersonPost = null, $appendix = null)
    {
        $this
            ->setLicenseNumber($licenseNumber)
            ->setLicenseDate($licenseDate)
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setSuspendDate($suspendDate)
            ->setFinDateResumed($finDateResumed)
            ->setLicenseActivities($licenseActivities)
            ->setStateId($stateId)
            ->setStateName($stateName)
            ->setRecipientName($recipientName)
            ->setRecipientAddress($recipientAddress)
            ->setOperationAddress($operationAddress)
            ->setAuthorizedPersonFio($authorizedPersonFio)
            ->setAuthorizedPersonPost($authorizedPersonPost)
            ->setAppendix($appendix);
    }
    /**
     * Get licenseNumber value
     * @return string|null
     */
    public function getLicenseNumber()
    {
        return $this->licenseNumber;
    }
    /**
     * Set licenseNumber value
     * @param string $licenseNumber
     * @return \StructType\LicenseDatumType
     */
    public function setLicenseNumber($licenseNumber = null)
    {
        $this->licenseNumber = $licenseNumber;
        return $this;
    }
    /**
     * Get licenseDate value
     * @return string|null
     */
    public function getLicenseDate()
    {
        return $this->licenseDate;
    }
    /**
     * Set licenseDate value
     * @param string $licenseDate
     * @return \StructType\LicenseDatumType
     */
    public function setLicenseDate($licenseDate = null)
    {
        $this->licenseDate = $licenseDate;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\LicenseDatumType
     */
    public function setStartDate($startDate = null)
    {
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->finDate;
    }
    /**
     * Set finDate value
     * @param string $finDate
     * @return \StructType\LicenseDatumType
     */
    public function setFinDate($finDate = null)
    {
        $this->finDate = $finDate;
        return $this;
    }
    /**
     * Get suspendDate value
     * @return string|null
     */
    public function getSuspendDate()
    {
        return $this->suspendDate;
    }
    /**
     * Set suspendDate value
     * @param string $suspendDate
     * @return \StructType\LicenseDatumType
     */
    public function setSuspendDate($suspendDate = null)
    {
        $this->suspendDate = $suspendDate;
        return $this;
    }
    /**
     * Get finDateResumed value
     * @return string|null
     */
    public function getFinDateResumed()
    {
        return $this->finDateResumed;
    }
    /**
     * Set finDateResumed value
     * @param string $finDateResumed
     * @return \StructType\LicenseDatumType
     */
    public function setFinDateResumed($finDateResumed = null)
    {
        $this->finDateResumed = $finDateResumed;
        return $this;
    }
    /**
     * Get licenseActivities value
     * @return \StructType\LicenseActivityType[]|null
     */
    public function getLicenseActivities()
    {
        return $this->licenseActivities;
    }
    /**
     * Set licenseActivities value
     * @throws \InvalidArgumentException
     * @param \StructType\LicenseActivityType[] $licenseActivities
     * @return \StructType\LicenseDatumType
     */
    public function setLicenseActivities(array $licenseActivities = array())
    {
        $this->licenseActivities = $licenseActivities;
        return $this;
    }
    /**
     * Add item to licenseActivities value
     * @throws \InvalidArgumentException
     * @param \StructType\LicenseActivityType $item
     * @return \StructType\LicenseDatumType
     */
    public function addToLicenseActivities(\StructType\LicenseActivityType $item)
    {
        $this->licenseActivities[] = $item;
        return $this;
    }
    /**
     * Get stateId value
     * @return int|null
     */
    public function getStateId()
    {
        return $this->stateId;
    }
    /**
     * Set stateId value
     * @param int $stateId
     * @return \StructType\LicenseDatumType
     */
    public function setStateId($stateId = null)
    {
        $this->stateId = $stateId;
        return $this;
    }
    /**
     * Get stateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->stateName;
    }
    /**
     * Set stateName value
     * @param string $stateName
     * @return \StructType\LicenseDatumType
     */
    public function setStateName($stateName = null)
    {
        $this->stateName = $stateName;
        return $this;
    }
    /**
     * Get recipientName value
     * @return string|null
     */
    public function getRecipientName()
    {
        return $this->recipientName;
    }
    /**
     * Set recipientName value
     * @param string $recipientName
     * @return \StructType\LicenseDatumType
     */
    public function setRecipientName($recipientName = null)
    {
        $this->recipientName = $recipientName;
        return $this;
    }
    /**
     * Get recipientAddress value
     * @return string|null
     */
    public function getRecipientAddress()
    {
        return $this->recipientAddress;
    }
    /**
     * Set recipientAddress value
     * @param string $recipientAddress
     * @return \StructType\LicenseDatumType
     */
    public function setRecipientAddress($recipientAddress = null)
    {
        $this->recipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Get operationAddress value
     * @return string|null
     */
    public function getOperationAddress()
    {
        return $this->operationAddress;
    }
    /**
     * Set operationAddress value
     * @param string $operationAddress
     * @return \StructType\LicenseDatumType
     */
    public function setOperationAddress($operationAddress = null)
    {
        $this->operationAddress = $operationAddress;
        return $this;
    }
    /**
     * Get authorizedPersonFio value
     * @return string|null
     */
    public function getAuthorizedPersonFio()
    {
        return $this->authorizedPersonFio;
    }
    /**
     * Set authorizedPersonFio value
     * @param string $authorizedPersonFio
     * @return \StructType\LicenseDatumType
     */
    public function setAuthorizedPersonFio($authorizedPersonFio = null)
    {
        $this->authorizedPersonFio = $authorizedPersonFio;
        return $this;
    }
    /**
     * Get authorizedPersonPost value
     * @return string|null
     */
    public function getAuthorizedPersonPost()
    {
        return $this->authorizedPersonPost;
    }
    /**
     * Set authorizedPersonPost value
     * @param string $authorizedPersonPost
     * @return \StructType\LicenseDatumType
     */
    public function setAuthorizedPersonPost($authorizedPersonPost = null)
    {
        $this->authorizedPersonPost = $authorizedPersonPost;
        return $this;
    }
    /**
     * Get appendix value
     * @return string|null
     */
    public function getAppendix()
    {
        return $this->appendix;
    }
    /**
     * Set appendix value
     * @param string $appendix
     * @return \StructType\LicenseDatumType
     */
    public function setAppendix($appendix = null)
    {
        $this->appendix = $appendix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicenseDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
