<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KKTDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений KKTDataType "Наличие ККТ"
 * @subpackage Structs
 */
class KKTDataType extends InformationType
{
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - documentation: Модель, наименование ККТ | ИР ККТ п.7 раздел 1 | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ModelName;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - documentation: Заводской номер ККТ | ИР ККТ п.11 раздел 1 | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $SerialNumber;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места установки (нахождения) ККТ | ИР ККТ п.17 раздел 1 по КЛАДР | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * Constructor method for KKTDataType
     * @uses KKTDataType::setModelName()
     * @uses KKTDataType::setSerialNumber()
     * @uses KKTDataType::setAddress()
     * @param string $modelName
     * @param string $serialNumber
     * @param string $address
     */
    public function __construct($modelName = null, $serialNumber = null, $address = null)
    {
        $this
            ->setModelName($modelName)
            ->setSerialNumber($serialNumber)
            ->setAddress($address);
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \StructType\KKTDataType
     */
    public function setModelName($modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \StructType\KKTDataType
     */
    public function setSerialNumber($serialNumber = null)
    {
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\KKTDataType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KKTDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
