<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationRegistryQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос в реестр розыска
 * - type: tns:InvestigationRegistryQuery
 * @subpackage Structs
 */
class InvestigationRegistryQuery extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Тип разыскиваемого лица | Указывается тип разыскиваемого лица, либо лица, чье имущество разыскивается
     * @var string
     */
    public $Type;
    /**
     * The InvFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО разыскиваемого лица | Указывается разыскиваемое лицо (Ф.И.О. гражданина, ребёнка), либо лицо, чье имущество разыскивается.
     * Допустимо заполнение только одного из полей «ФИО разыскиваемого лица» или «Наименование организации»
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $InvFio;
    /**
     * The InvName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование организации | Указывается разыскиваемая организация (наименование организации), либо организация, чье имущество
     * разыскивается. Допустимо заполнение только одного из полей «ФИО разыскиваемого лица» или «Наименование организации» | Строка длиной от
     * 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $InvName;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Указывается дата рождения разыскиваемого лица либо гражданина, чье имущество разыскивается, если известена |
     * Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BirthDate;
    /**
     * The BirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения | Указывается год рождения разыскиваемого лица либо гражданина, чье имущество разыскивается, если известен | Год
     * (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $BirthYear;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН организации | Указывается ИНН разыскиваемой организации либо организации, чье имущество разыскивается. Поле обязательное
     * для заполнения, если тип разыскиваемого лица — юридическое лицо | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Указывается номер ИП. Используется для поиска розыскного дела в реестре розыска | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The Aliment
     * Meta informations extracted from the WSDL
     * - documentation: Алиментные обязательства | Признак поиска разыскиваемого лица, являющегося должником по алиментным обязательствам. Если
     * признак отсутствует в схеме, то по умолчанию принимает значение «true». | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $Aliment;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for InvestigationRegistryQuery
     * @uses InvestigationRegistryQuery::setExternalKey()
     * @uses InvestigationRegistryQuery::setType()
     * @uses InvestigationRegistryQuery::setInvFio()
     * @uses InvestigationRegistryQuery::setInvName()
     * @uses InvestigationRegistryQuery::setBirthDate()
     * @uses InvestigationRegistryQuery::setBirthYear()
     * @uses InvestigationRegistryQuery::setINN()
     * @uses InvestigationRegistryQuery::setIPNumber()
     * @uses InvestigationRegistryQuery::setAliment()
     * @uses InvestigationRegistryQuery::setSignature()
     * @uses InvestigationRegistryQuery::setId()
     * @param string $externalKey
     * @param string $type
     * @param \StructType\FioType $invFio
     * @param string $invName
     * @param string $birthDate
     * @param string $birthYear
     * @param string $iNN
     * @param string $iPNumber
     * @param bool $aliment
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $type = null, \StructType\FioType $invFio = null, $invName = null, $birthDate = null, $birthYear = null, $iNN = null, $iPNumber = null, $aliment = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setType($type)
            ->setInvFio($invFio)
            ->setInvName($invName)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setINN($iNN)
            ->setIPNumber($iPNumber)
            ->setAliment($aliment)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get InvFio value
     * @return \StructType\FioType|null
     */
    public function getInvFio()
    {
        return $this->InvFio;
    }
    /**
     * Set InvFio value
     * @param \StructType\FioType $invFio
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setInvFio(\StructType\FioType $invFio = null)
    {
        $this->InvFio = $invFio;
        return $this;
    }
    /**
     * Get InvName value
     * @return string|null
     */
    public function getInvName()
    {
        return $this->InvName;
    }
    /**
     * Set InvName value
     * @param string $invName
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setInvName($invName = null)
    {
        $this->InvName = $invName;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setBirthDate($birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get BirthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->BirthYear;
    }
    /**
     * Set BirthYear value
     * @param string $birthYear
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setBirthYear($birthYear = null)
    {
        $this->BirthYear = $birthYear;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setIPNumber($iPNumber = null)
    {
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get Aliment value
     * @return bool|null
     */
    public function getAliment()
    {
        return $this->Aliment;
    }
    /**
     * Set Aliment value
     * @param bool $aliment
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setAliment($aliment = null)
    {
        $this->Aliment = $aliment;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\InvestigationRegistryQuery
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\InvestigationRegistryQuery
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvestigationRegistryQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
