<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationRegistryInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра розыска
 * - type: tns:InvestigationRegistryInfo
 * @subpackage Structs
 */
class InvestigationRegistryInfo extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор документа, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The QueryExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса (значение поля ExternalKey), переданного ранее в ФССП России | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $QueryExternalKey;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Тип рaзыскиваемого лица | Указывается тип разыскиваемого лица, либо лица, чье имущество разыскивается
     * @var string
     */
    public $Type;
    /**
     * The InvFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО разыскиваемого лица | Указывается разыскиваемое лицо (Ф.И.О. гражданина, ребёнка), либо лицо, чье имущество разыскивается.
     * Допустимо заполнение только одного из полей «ФИО разыскиваемого лица» или «Наименование организации»
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $InvFio;
    /**
     * The InvName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование организации | Указывается разыскиваемая организация (наименование организации), либо организация, чье имущество
     * разыскивается. Допустимо заполнение только одного из полей «ФИО разыскиваемого лица» или «Наименование организации» | Строка длиной от
     * 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $InvName;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Указывается дата рождения разыскиваемого лица либо гражданина, чье имущество разыскивается, если известна |
     * Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BirthDate;
    /**
     * The BirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения | Указывается год рождения разыскиваемого лица либо гражданина, чье имущество разыскивается, если известен | Год
     * (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $BirthYear;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН организации | Указывается ИНН должника. Поле обязательное для заполнения, если тип разыскиваемого лица — юридическое лицо
     * | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Указывается номер ИП, в рамках которого возбуждено розыскное дело | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - documentation: Состав выписки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvestigationRegistryDetail[]
     */
    public $Detail;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for InvestigationRegistryInfo
     * @uses InvestigationRegistryInfo::setInternalKey()
     * @uses InvestigationRegistryInfo::setQueryExternalKey()
     * @uses InvestigationRegistryInfo::setType()
     * @uses InvestigationRegistryInfo::setInvFio()
     * @uses InvestigationRegistryInfo::setInvName()
     * @uses InvestigationRegistryInfo::setBirthDate()
     * @uses InvestigationRegistryInfo::setBirthYear()
     * @uses InvestigationRegistryInfo::setINN()
     * @uses InvestigationRegistryInfo::setIPNumber()
     * @uses InvestigationRegistryInfo::setDetail()
     * @uses InvestigationRegistryInfo::setSignature()
     * @uses InvestigationRegistryInfo::setId()
     * @param int $internalKey
     * @param string $queryExternalKey
     * @param string $type
     * @param \StructType\FioType $invFio
     * @param string $invName
     * @param string $birthDate
     * @param string $birthYear
     * @param string $iNN
     * @param string $iPNumber
     * @param \StructType\InvestigationRegistryDetail[] $detail
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $queryExternalKey = null, $type = null, \StructType\FioType $invFio = null, $invName = null, $birthDate = null, $birthYear = null, $iNN = null, $iPNumber = null, array $detail = array(), array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setQueryExternalKey($queryExternalKey)
            ->setType($type)
            ->setInvFio($invFio)
            ->setInvName($invName)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setINN($iNN)
            ->setIPNumber($iPNumber)
            ->setDetail($detail)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get QueryExternalKey value
     * @return string|null
     */
    public function getQueryExternalKey()
    {
        return $this->QueryExternalKey;
    }
    /**
     * Set QueryExternalKey value
     * @param string $queryExternalKey
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setQueryExternalKey($queryExternalKey = null)
    {
        $this->QueryExternalKey = $queryExternalKey;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get InvFio value
     * @return \StructType\FioType|null
     */
    public function getInvFio()
    {
        return $this->InvFio;
    }
    /**
     * Set InvFio value
     * @param \StructType\FioType $invFio
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setInvFio(\StructType\FioType $invFio = null)
    {
        $this->InvFio = $invFio;
        return $this;
    }
    /**
     * Get InvName value
     * @return string|null
     */
    public function getInvName()
    {
        return $this->InvName;
    }
    /**
     * Set InvName value
     * @param string $invName
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setInvName($invName = null)
    {
        $this->InvName = $invName;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setBirthDate($birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get BirthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->BirthYear;
    }
    /**
     * Set BirthYear value
     * @param string $birthYear
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setBirthYear($birthYear = null)
    {
        $this->BirthYear = $birthYear;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setIPNumber($iPNumber = null)
    {
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get Detail value
     * @return \StructType\InvestigationRegistryDetail[]|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationRegistryDetail[] $detail
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setDetail(array $detail = array())
    {
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationRegistryDetail $item
     * @return \StructType\InvestigationRegistryInfo
     */
    public function addToDetail(\StructType\InvestigationRegistryDetail $item)
    {
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\InvestigationRegistryInfo
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\InvestigationRegistryInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvestigationRegistryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
