<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationRegistryDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Строка выписки из реестра розыска
 * @subpackage Structs
 */
class InvestigationRegistryDetail extends AbstractStructBase
{
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заведения розыскного дела | Указывается дата заведения розыскного дела | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер розыскного дела | Указывается номер розыскного дела | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IssueNumber;
    /**
     * The IsDurationOverMonth
     * Meta informations extracted from the WSDL
     * - documentation: Срок нахождения в реестре больше месяца | Признак устанавливается в активное состояние, если с момента загрузки розыскного
     * дела в реестр розыска прошло больше месяца | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsDurationOverMonth;
    /**
     * The invCategory
     * Meta informations extracted from the WSDL
     * - documentation: Категория розыска | Указывается тип розыскного дела (должник-организация, имущество должника-организации, должник-физическое
     * лицо, имущество должника-физического лица, ребёнок) | Категория розыска
     * - length: 1
     * @var string
     */
    public $invCategory;
    /**
     * Constructor method for InvestigationRegistryDetail
     * @uses InvestigationRegistryDetail::setIssueDate()
     * @uses InvestigationRegistryDetail::setIssueNumber()
     * @uses InvestigationRegistryDetail::setIsDurationOverMonth()
     * @uses InvestigationRegistryDetail::setInvCategory()
     * @param string $issueDate
     * @param string $issueNumber
     * @param bool $isDurationOverMonth
     * @param string $invCategory
     */
    public function __construct($issueDate = null, $issueNumber = null, $isDurationOverMonth = null, $invCategory = null)
    {
        $this
            ->setIssueDate($issueDate)
            ->setIssueNumber($issueNumber)
            ->setIsDurationOverMonth($isDurationOverMonth)
            ->setInvCategory($invCategory);
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\InvestigationRegistryDetail
     */
    public function setIssueDate($issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->IssueNumber;
    }
    /**
     * Set IssueNumber value
     * @param string $issueNumber
     * @return \StructType\InvestigationRegistryDetail
     */
    public function setIssueNumber($issueNumber = null)
    {
        $this->IssueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get IsDurationOverMonth value
     * @return bool|null
     */
    public function getIsDurationOverMonth()
    {
        return $this->IsDurationOverMonth;
    }
    /**
     * Set IsDurationOverMonth value
     * @param bool $isDurationOverMonth
     * @return \StructType\InvestigationRegistryDetail
     */
    public function setIsDurationOverMonth($isDurationOverMonth = null)
    {
        $this->IsDurationOverMonth = $isDurationOverMonth;
        return $this;
    }
    /**
     * Get invCategory value
     * @return string|null
     */
    public function getInvCategory()
    {
        return $this->invCategory;
    }
    /**
     * Set invCategory value
     * @param string $invCategory
     * @return \StructType\InvestigationRegistryDetail
     */
    public function setInvCategory($invCategory = null)
    {
        $this->invCategory = $invCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvestigationRegistryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
