<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реестр розыска | ЭП
 * @subpackage Structs
 */
class InvestigationRegistry extends AbstractStructBase
{
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Строка длиной от 1 до 8 символов
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The unloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $unloadDate;
    /**
     * The invData
     * Meta informations extracted from the WSDL
     * - documentation: Данные розыска
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvestigationData[]
     */
    public $invData;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for InvestigationRegistry
     * @uses InvestigationRegistry::setVersion()
     * @uses InvestigationRegistry::setInternalKey()
     * @uses InvestigationRegistry::setOspCode()
     * @uses InvestigationRegistry::setDocDate()
     * @uses InvestigationRegistry::setDocNumber()
     * @uses InvestigationRegistry::setUnloadDate()
     * @uses InvestigationRegistry::setInvData()
     * @uses InvestigationRegistry::setSignDateTime()
     * @uses InvestigationRegistry::setSignature()
     * @param string $version
     * @param int $internalKey
     * @param string $ospCode
     * @param string $docDate
     * @param string $docNumber
     * @param string $unloadDate
     * @param \StructType\InvestigationData[] $invData
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($version = null, $internalKey = null, $ospCode = null, $docDate = null, $docNumber = null, $unloadDate = null, array $invData = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setVersion($version)
            ->setInternalKey($internalKey)
            ->setOspCode($ospCode)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setUnloadDate($unloadDate)
            ->setInvData($invData)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\InvestigationRegistry
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\InvestigationRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \StructType\InvestigationRegistry
     */
    public function setOspCode($ospCode = null)
    {
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\InvestigationRegistry
     */
    public function setDocDate($docDate = null)
    {
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\InvestigationRegistry
     */
    public function setDocNumber($docNumber = null)
    {
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get unloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->unloadDate;
    }
    /**
     * Set unloadDate value
     * @param string $unloadDate
     * @return \StructType\InvestigationRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->unloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get invData value
     * @return \StructType\InvestigationData[]|null
     */
    public function getInvData()
    {
        return $this->invData;
    }
    /**
     * Set invData value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationData[] $invData
     * @return \StructType\InvestigationRegistry
     */
    public function setInvData(array $invData = array())
    {
        $this->invData = $invData;
        return $this;
    }
    /**
     * Add item to invData value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationData $item
     * @return \StructType\InvestigationRegistry
     */
    public function addToInvData(\StructType\InvestigationData $item)
    {
        $this->invData[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\InvestigationRegistry
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\InvestigationRegistry
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\InvestigationRegistry
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvestigationRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
