<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationDataInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация об исполнительных производствах по реестру долга
 * - type: tns:InvestigationDataInfo
 * @subpackage Structs
 */
class InvestigationDataInfo extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The registryKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $registryKey;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The invData
     * Meta informations extracted from the WSDL
     * - documentation: Дата розыска | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $invData;
    /**
     * The issueNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер розыска | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $issueNumber;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The ip
     * Meta informations extracted from the WSDL
     * - documentation: ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPExt[]
     */
    public $ip;
    /**
     * Constructor method for InvestigationDataInfo
     * @uses InvestigationDataInfo::setInternalKey()
     * @uses InvestigationDataInfo::setRegistryKey()
     * @uses InvestigationDataInfo::setOspCode()
     * @uses InvestigationDataInfo::setInvData()
     * @uses InvestigationDataInfo::setIssueNumber()
     * @uses InvestigationDataInfo::setIPNum()
     * @uses InvestigationDataInfo::setIp()
     * @param int $internalKey
     * @param int $registryKey
     * @param string $ospCode
     * @param string $invData
     * @param string $issueNumber
     * @param string $iPNum
     * @param \StructType\IPExt[] $ip
     */
    public function __construct($internalKey = null, $registryKey = null, $ospCode = null, $invData = null, $issueNumber = null, $iPNum = null, array $ip = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setRegistryKey($registryKey)
            ->setOspCode($ospCode)
            ->setInvData($invData)
            ->setIssueNumber($issueNumber)
            ->setIPNum($iPNum)
            ->setIp($ip);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\InvestigationDataInfo
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get registryKey value
     * @return int|null
     */
    public function getRegistryKey()
    {
        return $this->registryKey;
    }
    /**
     * Set registryKey value
     * @param int $registryKey
     * @return \StructType\InvestigationDataInfo
     */
    public function setRegistryKey($registryKey = null)
    {
        $this->registryKey = $registryKey;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \StructType\InvestigationDataInfo
     */
    public function setOspCode($ospCode = null)
    {
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get invData value
     * @return string|null
     */
    public function getInvData()
    {
        return $this->invData;
    }
    /**
     * Set invData value
     * @param string $invData
     * @return \StructType\InvestigationDataInfo
     */
    public function setInvData($invData = null)
    {
        $this->invData = $invData;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param string $issueNumber
     * @return \StructType\InvestigationDataInfo
     */
    public function setIssueNumber($issueNumber = null)
    {
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \StructType\InvestigationDataInfo
     */
    public function setIPNum($iPNum = null)
    {
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get ip value
     * @return \StructType\IPExt[]|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @throws \InvalidArgumentException
     * @param \StructType\IPExt[] $ip
     * @return \StructType\InvestigationDataInfo
     */
    public function setIp(array $ip = array())
    {
        $this->ip = $ip;
        return $this;
    }
    /**
     * Add item to ip value
     * @throws \InvalidArgumentException
     * @param \StructType\IPExt $item
     * @return \StructType\InvestigationDataInfo
     */
    public function addToIp(\StructType\IPExt $item)
    {
        $this->ip[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvestigationDataInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
