<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные о разыскиваемом лице
 * - type: tns:InvestigationData
 * @subpackage Structs
 */
class InvestigationData extends AbstractStructBase
{
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The registryKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $registryKey;
    /**
     * The unloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $unloadDate;
    /**
     * The ipNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ipNumber;
    /**
     * The ipRiseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИП | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ipRiseDate;
    /**
     * The ipNumberComp
     * Meta informations extracted from the WSDL
     * - documentation: Номер сводного ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ipNumberComp;
    /**
     * The invCategory
     * Meta informations extracted from the WSDL
     * - documentation: Категория розыска | Категория розыска
     * - length: 1
     * @var string
     */
    public $invCategory;
    /**
     * The invDate
     * Meta informations extracted from the WSDL
     * - documentation: Розыск объявлен | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $invDate;
    /**
     * The issueNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $issueNumber;
    /**
     * The investigatedName
     * Meta informations extracted from the WSDL
     * - documentation: Разыскивается (лицо) | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $investigatedName;
    /**
     * The investigatedOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Разыскивается (организация) | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $investigatedOrgName;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $birthYear;
    /**
     * The parentName
     * Meta informations extracted from the WSDL
     * - documentation: Родитель | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $parentName;
    /**
     * The parentBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения родителя | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $parentBirthDate;
    /**
     * The parentBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения родителя | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $parentBirthYear;
    /**
     * The debtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес организации | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $debtorAddress;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $INN;
    /**
     * The SNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС должника | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $SNILS;
    /**
     * The PHOTO
     * Meta informations extracted from the WSDL
     * - documentation: Фотография должника | Заполняется закодированным в формате BASE64 фотоизображением должника, находящимся во вложении с типом
     * «Фотография» разыскного дела.
     * - minOccurs: 0
     * @var string
     */
    public $PHOTO;
    /**
     * Constructor method for InvestigationData
     * @uses InvestigationData::setOspCode()
     * @uses InvestigationData::setRegistryKey()
     * @uses InvestigationData::setUnloadDate()
     * @uses InvestigationData::setIpNumber()
     * @uses InvestigationData::setIpRiseDate()
     * @uses InvestigationData::setIpNumberComp()
     * @uses InvestigationData::setInvCategory()
     * @uses InvestigationData::setInvDate()
     * @uses InvestigationData::setIssueNumber()
     * @uses InvestigationData::setInvestigatedName()
     * @uses InvestigationData::setInvestigatedOrgName()
     * @uses InvestigationData::setBirthDate()
     * @uses InvestigationData::setBirthYear()
     * @uses InvestigationData::setParentName()
     * @uses InvestigationData::setParentBirthDate()
     * @uses InvestigationData::setParentBirthYear()
     * @uses InvestigationData::setDebtorAddress()
     * @uses InvestigationData::setINN()
     * @uses InvestigationData::setSNILS()
     * @uses InvestigationData::setPHOTO()
     * @param string $ospCode
     * @param int $registryKey
     * @param string $unloadDate
     * @param string $ipNumber
     * @param string $ipRiseDate
     * @param string $ipNumberComp
     * @param string $invCategory
     * @param string $invDate
     * @param string $issueNumber
     * @param string $investigatedName
     * @param string $investigatedOrgName
     * @param string $birthDate
     * @param string $birthYear
     * @param string $parentName
     * @param string $parentBirthDate
     * @param string $parentBirthYear
     * @param string $debtorAddress
     * @param string $iNN
     * @param string $sNILS
     * @param string $pHOTO
     */
    public function __construct($ospCode = null, $registryKey = null, $unloadDate = null, $ipNumber = null, $ipRiseDate = null, $ipNumberComp = null, $invCategory = null, $invDate = null, $issueNumber = null, $investigatedName = null, $investigatedOrgName = null, $birthDate = null, $birthYear = null, $parentName = null, $parentBirthDate = null, $parentBirthYear = null, $debtorAddress = null, $iNN = null, $sNILS = null, $pHOTO = null)
    {
        $this
            ->setOspCode($ospCode)
            ->setRegistryKey($registryKey)
            ->setUnloadDate($unloadDate)
            ->setIpNumber($ipNumber)
            ->setIpRiseDate($ipRiseDate)
            ->setIpNumberComp($ipNumberComp)
            ->setInvCategory($invCategory)
            ->setInvDate($invDate)
            ->setIssueNumber($issueNumber)
            ->setInvestigatedName($investigatedName)
            ->setInvestigatedOrgName($investigatedOrgName)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setParentName($parentName)
            ->setParentBirthDate($parentBirthDate)
            ->setParentBirthYear($parentBirthYear)
            ->setDebtorAddress($debtorAddress)
            ->setINN($iNN)
            ->setSNILS($sNILS)
            ->setPHOTO($pHOTO);
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \StructType\InvestigationData
     */
    public function setOspCode($ospCode = null)
    {
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get registryKey value
     * @return int|null
     */
    public function getRegistryKey()
    {
        return $this->registryKey;
    }
    /**
     * Set registryKey value
     * @param int $registryKey
     * @return \StructType\InvestigationData
     */
    public function setRegistryKey($registryKey = null)
    {
        $this->registryKey = $registryKey;
        return $this;
    }
    /**
     * Get unloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->unloadDate;
    }
    /**
     * Set unloadDate value
     * @param string $unloadDate
     * @return \StructType\InvestigationData
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->unloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get ipNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->ipNumber;
    }
    /**
     * Set ipNumber value
     * @param string $ipNumber
     * @return \StructType\InvestigationData
     */
    public function setIpNumber($ipNumber = null)
    {
        $this->ipNumber = $ipNumber;
        return $this;
    }
    /**
     * Get ipRiseDate value
     * @return string|null
     */
    public function getIpRiseDate()
    {
        return $this->ipRiseDate;
    }
    /**
     * Set ipRiseDate value
     * @param string $ipRiseDate
     * @return \StructType\InvestigationData
     */
    public function setIpRiseDate($ipRiseDate = null)
    {
        $this->ipRiseDate = $ipRiseDate;
        return $this;
    }
    /**
     * Get ipNumberComp value
     * @return string|null
     */
    public function getIpNumberComp()
    {
        return $this->ipNumberComp;
    }
    /**
     * Set ipNumberComp value
     * @param string $ipNumberComp
     * @return \StructType\InvestigationData
     */
    public function setIpNumberComp($ipNumberComp = null)
    {
        $this->ipNumberComp = $ipNumberComp;
        return $this;
    }
    /**
     * Get invCategory value
     * @return string|null
     */
    public function getInvCategory()
    {
        return $this->invCategory;
    }
    /**
     * Set invCategory value
     * @param string $invCategory
     * @return \StructType\InvestigationData
     */
    public function setInvCategory($invCategory = null)
    {
        $this->invCategory = $invCategory;
        return $this;
    }
    /**
     * Get invDate value
     * @return string|null
     */
    public function getInvDate()
    {
        return $this->invDate;
    }
    /**
     * Set invDate value
     * @param string $invDate
     * @return \StructType\InvestigationData
     */
    public function setInvDate($invDate = null)
    {
        $this->invDate = $invDate;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param string $issueNumber
     * @return \StructType\InvestigationData
     */
    public function setIssueNumber($issueNumber = null)
    {
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get investigatedName value
     * @return string|null
     */
    public function getInvestigatedName()
    {
        return $this->investigatedName;
    }
    /**
     * Set investigatedName value
     * @param string $investigatedName
     * @return \StructType\InvestigationData
     */
    public function setInvestigatedName($investigatedName = null)
    {
        $this->investigatedName = $investigatedName;
        return $this;
    }
    /**
     * Get investigatedOrgName value
     * @return string|null
     */
    public function getInvestigatedOrgName()
    {
        return $this->investigatedOrgName;
    }
    /**
     * Set investigatedOrgName value
     * @param string $investigatedOrgName
     * @return \StructType\InvestigationData
     */
    public function setInvestigatedOrgName($investigatedOrgName = null)
    {
        $this->investigatedOrgName = $investigatedOrgName;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\InvestigationData
     */
    public function setBirthDate($birthDate = null)
    {
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->birthYear;
    }
    /**
     * Set birthYear value
     * @param string $birthYear
     * @return \StructType\InvestigationData
     */
    public function setBirthYear($birthYear = null)
    {
        $this->birthYear = $birthYear;
        return $this;
    }
    /**
     * Get parentName value
     * @return string|null
     */
    public function getParentName()
    {
        return $this->parentName;
    }
    /**
     * Set parentName value
     * @param string $parentName
     * @return \StructType\InvestigationData
     */
    public function setParentName($parentName = null)
    {
        $this->parentName = $parentName;
        return $this;
    }
    /**
     * Get parentBirthDate value
     * @return string|null
     */
    public function getParentBirthDate()
    {
        return $this->parentBirthDate;
    }
    /**
     * Set parentBirthDate value
     * @param string $parentBirthDate
     * @return \StructType\InvestigationData
     */
    public function setParentBirthDate($parentBirthDate = null)
    {
        $this->parentBirthDate = $parentBirthDate;
        return $this;
    }
    /**
     * Get parentBirthYear value
     * @return string|null
     */
    public function getParentBirthYear()
    {
        return $this->parentBirthYear;
    }
    /**
     * Set parentBirthYear value
     * @param string $parentBirthYear
     * @return \StructType\InvestigationData
     */
    public function setParentBirthYear($parentBirthYear = null)
    {
        $this->parentBirthYear = $parentBirthYear;
        return $this;
    }
    /**
     * Get debtorAddress value
     * @return string|null
     */
    public function getDebtorAddress()
    {
        return $this->debtorAddress;
    }
    /**
     * Set debtorAddress value
     * @param string $debtorAddress
     * @return \StructType\InvestigationData
     */
    public function setDebtorAddress($debtorAddress = null)
    {
        $this->debtorAddress = $debtorAddress;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\InvestigationData
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get SNILS value
     * @return string|null
     */
    public function getSNILS()
    {
        return $this->SNILS;
    }
    /**
     * Set SNILS value
     * @param string $sNILS
     * @return \StructType\InvestigationData
     */
    public function setSNILS($sNILS = null)
    {
        $this->SNILS = $sNILS;
        return $this;
    }
    /**
     * Get PHOTO value
     * @return string|null
     */
    public function getPHOTO()
    {
        return $this->PHOTO;
    }
    /**
     * Set PHOTO value
     * @param string $pHOTO
     * @return \StructType\InvestigationData
     */
    public function setPHOTO($pHOTO = null)
    {
        $this->PHOTO = $pHOTO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvestigationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
