<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InquiryMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос интерактивный (синхронный) | ЭЦП | Технологическая ЭЦП (накладывается сервером, формирующим сообщение)
 * @subpackage Structs
 */
class InquiryMessage extends SyncRq
{
    /**
     * The debtorIPListRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реестра ИП по должнику
     * @var \StructType\DebtorIPListRequestType
     */
    public $debtorIPListRequest;
    /**
     * The IPSideRequestExistence
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о наличии ИП
     * @var \StructType\IPSideRequestExistenceType
     */
    public $IPSideRequestExistence;
    /**
     * The IPSideRequestCourseID
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по исполнительному документу
     * @var \StructType\IPSideRequestCourseIDType
     */
    public $IPSideRequestCourseID;
    /**
     * The IPSideRequestCourseIP
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по номеру ИП
     * @var \StructType\IPSideRequestCourseIPType
     */
    public $IPSideRequestCourseIP;
    /**
     * The IPReqAppResultRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос на получение ответов на заявления или запросы в ОСП
     * @var \StructType\IPReqAppResultRequestType
     */
    public $IPReqAppResultRequest;
    /**
     * The IPBriefInfoRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос сведений ИП по номеру ИП
     * @var \StructType\IPBriefInfoRequestType
     */
    public $IPBriefInfoRequest;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for InquiryMessage
     * @uses InquiryMessage::setDebtorIPListRequest()
     * @uses InquiryMessage::setIPSideRequestExistence()
     * @uses InquiryMessage::setIPSideRequestCourseID()
     * @uses InquiryMessage::setIPSideRequestCourseIP()
     * @uses InquiryMessage::setIPReqAppResultRequest()
     * @uses InquiryMessage::setIPBriefInfoRequest()
     * @uses InquiryMessage::setSignature()
     * @param \StructType\DebtorIPListRequestType $debtorIPListRequest
     * @param \StructType\IPSideRequestExistenceType $iPSideRequestExistence
     * @param \StructType\IPSideRequestCourseIDType $iPSideRequestCourseID
     * @param \StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP
     * @param \StructType\IPReqAppResultRequestType $iPReqAppResultRequest
     * @param \StructType\IPBriefInfoRequestType $iPBriefInfoRequest
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct(\StructType\DebtorIPListRequestType $debtorIPListRequest = null, \StructType\IPSideRequestExistenceType $iPSideRequestExistence = null, \StructType\IPSideRequestCourseIDType $iPSideRequestCourseID = null, \StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP = null, \StructType\IPReqAppResultRequestType $iPReqAppResultRequest = null, \StructType\IPBriefInfoRequestType $iPBriefInfoRequest = null, array $signature = array())
    {
        $this
            ->setDebtorIPListRequest($debtorIPListRequest)
            ->setIPSideRequestExistence($iPSideRequestExistence)
            ->setIPSideRequestCourseID($iPSideRequestCourseID)
            ->setIPSideRequestCourseIP($iPSideRequestCourseIP)
            ->setIPReqAppResultRequest($iPReqAppResultRequest)
            ->setIPBriefInfoRequest($iPBriefInfoRequest)
            ->setSignature($signature);
    }
    /**
     * Get debtorIPListRequest value
     * @return \StructType\DebtorIPListRequestType|null
     */
    public function getDebtorIPListRequest()
    {
        return $this->debtorIPListRequest;
    }
    /**
     * Set debtorIPListRequest value
     * @param \StructType\DebtorIPListRequestType $debtorIPListRequest
     * @return \StructType\InquiryMessage
     */
    public function setDebtorIPListRequest(\StructType\DebtorIPListRequestType $debtorIPListRequest = null)
    {
        $this->debtorIPListRequest = $debtorIPListRequest;
        return $this;
    }
    /**
     * Get IPSideRequestExistence value
     * @return \StructType\IPSideRequestExistenceType|null
     */
    public function getIPSideRequestExistence()
    {
        return $this->IPSideRequestExistence;
    }
    /**
     * Set IPSideRequestExistence value
     * @param \StructType\IPSideRequestExistenceType $iPSideRequestExistence
     * @return \StructType\InquiryMessage
     */
    public function setIPSideRequestExistence(\StructType\IPSideRequestExistenceType $iPSideRequestExistence = null)
    {
        $this->IPSideRequestExistence = $iPSideRequestExistence;
        return $this;
    }
    /**
     * Get IPSideRequestCourseID value
     * @return \StructType\IPSideRequestCourseIDType|null
     */
    public function getIPSideRequestCourseID()
    {
        return $this->IPSideRequestCourseID;
    }
    /**
     * Set IPSideRequestCourseID value
     * @param \StructType\IPSideRequestCourseIDType $iPSideRequestCourseID
     * @return \StructType\InquiryMessage
     */
    public function setIPSideRequestCourseID(\StructType\IPSideRequestCourseIDType $iPSideRequestCourseID = null)
    {
        $this->IPSideRequestCourseID = $iPSideRequestCourseID;
        return $this;
    }
    /**
     * Get IPSideRequestCourseIP value
     * @return \StructType\IPSideRequestCourseIPType|null
     */
    public function getIPSideRequestCourseIP()
    {
        return $this->IPSideRequestCourseIP;
    }
    /**
     * Set IPSideRequestCourseIP value
     * @param \StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP
     * @return \StructType\InquiryMessage
     */
    public function setIPSideRequestCourseIP(\StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP = null)
    {
        $this->IPSideRequestCourseIP = $iPSideRequestCourseIP;
        return $this;
    }
    /**
     * Get IPReqAppResultRequest value
     * @return \StructType\IPReqAppResultRequestType|null
     */
    public function getIPReqAppResultRequest()
    {
        return $this->IPReqAppResultRequest;
    }
    /**
     * Set IPReqAppResultRequest value
     * @param \StructType\IPReqAppResultRequestType $iPReqAppResultRequest
     * @return \StructType\InquiryMessage
     */
    public function setIPReqAppResultRequest(\StructType\IPReqAppResultRequestType $iPReqAppResultRequest = null)
    {
        $this->IPReqAppResultRequest = $iPReqAppResultRequest;
        return $this;
    }
    /**
     * Get IPBriefInfoRequest value
     * @return \StructType\IPBriefInfoRequestType|null
     */
    public function getIPBriefInfoRequest()
    {
        return $this->IPBriefInfoRequest;
    }
    /**
     * Set IPBriefInfoRequest value
     * @param \StructType\IPBriefInfoRequestType $iPBriefInfoRequest
     * @return \StructType\InquiryMessage
     */
    public function setIPBriefInfoRequest(\StructType\IPBriefInfoRequestType $iPBriefInfoRequest = null)
    {
        $this->IPBriefInfoRequest = $iPBriefInfoRequest;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\InquiryMessage
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\InquiryMessage
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InquiryMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
