<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingForcedExecDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Входящий документ принудительного исполнения | Используется приема документов от внешних контрагентов
 * - type: tns:IncomingForcedExecDocument
 * @subpackage Structs
 */
class IncomingForcedExecDocument extends AbstractStructBase
{
    /**
     * The SenderProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты внешнего контрагента
     * - minOccurs: 1
     * @var \StructType\SenderContragentType
     */
    public $SenderProperties;
    /**
     * The SideProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты стороны ИП
     * - minOccurs: 1
     * @var \StructType\ContragentDatumType
     */
    public $SideProperties;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС внешних контрагентов | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом
     * (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The OutgoingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор исходящего документа АИС ФССП России | Обязательно, если данный документ направляется в ответ на исходящий
     * документ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $OutgoingDocKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Обязательно, если данный документ направлен в ответ на документ, содержащий сведения об исполнительном
     * производстве | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The ProcDocRef
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Обязательно для документов: - Уведомление о готовности к реализации арестованного имущества - Отчет о
     * результатах реализации арестованного имущества
     * - minOccurs: 0
     * @var \StructType\DocRefType
     */
    public $ProcDocRef;
    /**
     * The DocumentData
     * Meta informations extracted from the WSDL
     * - documentation: Документ в формате ПИЭВ
     * @var \StructType\EmbeddedDocumentType
     */
    public $DocumentData;
    /**
     * Constructor method for IncomingForcedExecDocument
     * @uses IncomingForcedExecDocument::setSenderProperties()
     * @uses IncomingForcedExecDocument::setSideProperties()
     * @uses IncomingForcedExecDocument::setExternalKey()
     * @uses IncomingForcedExecDocument::setOutgoingDocKey()
     * @uses IncomingForcedExecDocument::setIpInternalKey()
     * @uses IncomingForcedExecDocument::setProcDocRef()
     * @uses IncomingForcedExecDocument::setDocumentData()
     * @param \StructType\SenderContragentType $senderProperties
     * @param \StructType\ContragentDatumType $sideProperties
     * @param string $externalKey
     * @param int $outgoingDocKey
     * @param int $ipInternalKey
     * @param \StructType\DocRefType $procDocRef
     * @param \StructType\EmbeddedDocumentType $documentData
     */
    public function __construct(\StructType\SenderContragentType $senderProperties = null, \StructType\ContragentDatumType $sideProperties = null, $externalKey = null, $outgoingDocKey = null, $ipInternalKey = null, \StructType\DocRefType $procDocRef = null, \StructType\EmbeddedDocumentType $documentData = null)
    {
        $this
            ->setSenderProperties($senderProperties)
            ->setSideProperties($sideProperties)
            ->setExternalKey($externalKey)
            ->setOutgoingDocKey($outgoingDocKey)
            ->setIpInternalKey($ipInternalKey)
            ->setProcDocRef($procDocRef)
            ->setDocumentData($documentData);
    }
    /**
     * Get SenderProperties value
     * @return \StructType\SenderContragentType
     */
    public function getSenderProperties()
    {
        return $this->SenderProperties;
    }
    /**
     * Set SenderProperties value
     * @param \StructType\SenderContragentType $senderProperties
     * @return \StructType\IncomingForcedExecDocument
     */
    public function setSenderProperties(\StructType\SenderContragentType $senderProperties = null)
    {
        $this->SenderProperties = $senderProperties;
        return $this;
    }
    /**
     * Get SideProperties value
     * @return \StructType\ContragentDatumType
     */
    public function getSideProperties()
    {
        return $this->SideProperties;
    }
    /**
     * Set SideProperties value
     * @param \StructType\ContragentDatumType $sideProperties
     * @return \StructType\IncomingForcedExecDocument
     */
    public function setSideProperties(\StructType\ContragentDatumType $sideProperties = null)
    {
        $this->SideProperties = $sideProperties;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\IncomingForcedExecDocument
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get OutgoingDocKey value
     * @return int|null
     */
    public function getOutgoingDocKey()
    {
        return $this->OutgoingDocKey;
    }
    /**
     * Set OutgoingDocKey value
     * @param int $outgoingDocKey
     * @return \StructType\IncomingForcedExecDocument
     */
    public function setOutgoingDocKey($outgoingDocKey = null)
    {
        $this->OutgoingDocKey = $outgoingDocKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\IncomingForcedExecDocument
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get ProcDocRef value
     * @return \StructType\DocRefType|null
     */
    public function getProcDocRef()
    {
        return $this->ProcDocRef;
    }
    /**
     * Set ProcDocRef value
     * @param \StructType\DocRefType $procDocRef
     * @return \StructType\IncomingForcedExecDocument
     */
    public function setProcDocRef(\StructType\DocRefType $procDocRef = null)
    {
        $this->ProcDocRef = $procDocRef;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return \StructType\EmbeddedDocumentType|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param \StructType\EmbeddedDocumentType $documentData
     * @return \StructType\IncomingForcedExecDocument
     */
    public function setDocumentData(\StructType\EmbeddedDocumentType $documentData = null)
    {
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IncomingForcedExecDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
