<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideRequestCourseIPType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPSideRequestCourseIPType «Регистрация запроса о ходе ИП по номеру ИП» | ЭП
 * @subpackage Structs
 */
class IPSideRequestCourseIPType extends IPSideRequestType
{
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер исполнительного производства | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The IsInteractive
     * Meta informations extracted from the WSDL
     * - documentation: Признак интерактивного запроса | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsInteractive;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPSideRequestCourseIPType
     * @uses IPSideRequestCourseIPType::setIPNumber()
     * @uses IPSideRequestCourseIPType::setIsInteractive()
     * @uses IPSideRequestCourseIPType::setSignature()
     * @uses IPSideRequestCourseIPType::setId()
     * @param string $iPNumber
     * @param bool $isInteractive
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($iPNumber = null, $isInteractive = null, array $signature = array(), $id = null)
    {
        $this
            ->setIPNumber($iPNumber)
            ->setIsInteractive($isInteractive)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \StructType\IPSideRequestCourseIPType
     */
    public function setIPNumber($iPNumber = null)
    {
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get IsInteractive value
     * @return bool|null
     */
    public function getIsInteractive()
    {
        return $this->IsInteractive;
    }
    /**
     * Set IsInteractive value
     * @param bool $isInteractive
     * @return \StructType\IPSideRequestCourseIPType
     */
    public function setIsInteractive($isInteractive = null)
    {
        $this->IsInteractive = $isInteractive;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPSideRequestCourseIPType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPSideRequestCourseIPType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IPSideRequestCourseIPType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPSideRequestCourseIPType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
