<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideRequestCourseIDType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPSideRequestCourseIDType «Регистрация запроса о ходе ИП по исполнительному документу» | ЭП
 * @subpackage Structs
 */
class IPSideRequestCourseIDType extends IPSideRequestType
{
    /**
     * The IDTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД
     * @var string
     */
    public $IDTypeCode;
    /**
     * The IDNumber
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNumber;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDSubjectText
     * Meta informations extracted from the WSDL
     * - documentation: Предмет исполнения | Строка длиной от 1 до 500 символов
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $IDSubjectText;
    /**
     * The IDCourtName
     * Meta informations extracted from the WSDL
     * - documentation: Орган выдавший исполнительный документ | Строка длиной от 1 до 250 символов
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $IDCourtName;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPSideRequestCourseIDType
     * @uses IPSideRequestCourseIDType::setIDTypeCode()
     * @uses IPSideRequestCourseIDType::setIDNumber()
     * @uses IPSideRequestCourseIDType::setIDDate()
     * @uses IPSideRequestCourseIDType::setIDSubjectText()
     * @uses IPSideRequestCourseIDType::setIDCourtName()
     * @uses IPSideRequestCourseIDType::setSignature()
     * @uses IPSideRequestCourseIDType::setId()
     * @param string $iDTypeCode
     * @param string $iDNumber
     * @param string $iDDate
     * @param string $iDSubjectText
     * @param string $iDCourtName
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($iDTypeCode = null, $iDNumber = null, $iDDate = null, $iDSubjectText = null, $iDCourtName = null, array $signature = array(), $id = null)
    {
        $this
            ->setIDTypeCode($iDTypeCode)
            ->setIDNumber($iDNumber)
            ->setIDDate($iDDate)
            ->setIDSubjectText($iDSubjectText)
            ->setIDCourtName($iDCourtName)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get IDTypeCode value
     * @return string|null
     */
    public function getIDTypeCode()
    {
        return $this->IDTypeCode;
    }
    /**
     * Set IDTypeCode value
     * @uses \EnumType\IdType::valueIsValid()
     * @uses \EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDTypeCode
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function setIDTypeCode($iDTypeCode = null)
    {
        $this->IDTypeCode = $iDTypeCode;
        return $this;
    }
    /**
     * Get IDNumber value
     * @return string|null
     */
    public function getIDNumber()
    {
        return $this->IDNumber;
    }
    /**
     * Set IDNumber value
     * @param string $iDNumber
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function setIDNumber($iDNumber = null)
    {
        $this->IDNumber = $iDNumber;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function setIDDate($iDDate = null)
    {
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDSubjectText value
     * @return string|null
     */
    public function getIDSubjectText()
    {
        return $this->IDSubjectText;
    }
    /**
     * Set IDSubjectText value
     * @param string $iDSubjectText
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function setIDSubjectText($iDSubjectText = null)
    {
        $this->IDSubjectText = $iDSubjectText;
        return $this;
    }
    /**
     * Get IDCourtName value
     * @return string|null
     */
    public function getIDCourtName()
    {
        return $this->IDCourtName;
    }
    /**
     * Set IDCourtName value
     * @param string $iDCourtName
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function setIDCourtName($iDCourtName = null)
    {
        $this->IDCourtName = $iDCourtName;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IPSideRequestCourseIDType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPSideRequestCourseIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
