<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос стороны ИП | Документ содержит запрос Ведомства, являющегося стороной ИП, сведений по исполнительному производству
 * - type: tns:IPSideQuery
 * @subpackage Structs
 */
class IPSideQuery extends AbstractStructBase
{
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП строковый | Номер документа
     * - minOccurs: 1
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string[]
     */
    public $DocType;
    /**
     * The DocDateBegin
     * Meta informations extracted from the WSDL
     * - documentation: Начальная дата | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDateBegin;
    /**
     * The DocDateEnd
     * Meta informations extracted from the WSDL
     * - documentation: Конечная дата (включительно) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDateEnd;
    /**
     * The Subscription
     * Meta informations extracted from the WSDL
     * - documentation: Подписка на рассылку документов | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $Subscription;
    /**
     * Constructor method for IPSideQuery
     * @uses IPSideQuery::setIPNum()
     * @uses IPSideQuery::setExternalKey()
     * @uses IPSideQuery::setIpInternalKey()
     * @uses IPSideQuery::setIdExternalKey()
     * @uses IPSideQuery::setDocType()
     * @uses IPSideQuery::setDocDateBegin()
     * @uses IPSideQuery::setDocDateEnd()
     * @uses IPSideQuery::setSubscription()
     * @param string $iPNum
     * @param string $externalKey
     * @param int $ipInternalKey
     * @param string $idExternalKey
     * @param string[] $docType
     * @param string $docDateBegin
     * @param string $docDateEnd
     * @param bool $subscription
     */
    public function __construct($iPNum = null, $externalKey = null, $ipInternalKey = null, $idExternalKey = null, array $docType = array(), $docDateBegin = null, $docDateEnd = null, $subscription = null)
    {
        $this
            ->setIPNum($iPNum)
            ->setExternalKey($externalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setIdExternalKey($idExternalKey)
            ->setDocType($docType)
            ->setDocDateBegin($docDateBegin)
            ->setDocDateEnd($docDateEnd)
            ->setSubscription($subscription);
    }
    /**
     * Get IPNum value
     * @return string
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \StructType\IPSideQuery
     */
    public function setIPNum($iPNum = null)
    {
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\IPSideQuery
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\IPSideQuery
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \StructType\IPSideQuery
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get DocType value
     * @return string[]|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @throws \InvalidArgumentException
     * @param string[] $docType
     * @return \StructType\IPSideQuery
     */
    public function setDocType(array $docType = array())
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Add item to DocType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IPSideQuery
     */
    public function addToDocType($item)
    {
        $this->DocType[] = $item;
        return $this;
    }
    /**
     * Get DocDateBegin value
     * @return string|null
     */
    public function getDocDateBegin()
    {
        return $this->DocDateBegin;
    }
    /**
     * Set DocDateBegin value
     * @param string $docDateBegin
     * @return \StructType\IPSideQuery
     */
    public function setDocDateBegin($docDateBegin = null)
    {
        $this->DocDateBegin = $docDateBegin;
        return $this;
    }
    /**
     * Get DocDateEnd value
     * @return string|null
     */
    public function getDocDateEnd()
    {
        return $this->DocDateEnd;
    }
    /**
     * Set DocDateEnd value
     * @param string $docDateEnd
     * @return \StructType\IPSideQuery
     */
    public function setDocDateEnd($docDateEnd = null)
    {
        $this->DocDateEnd = $docDateEnd;
        return $this;
    }
    /**
     * Get Subscription value
     * @return bool|null
     */
    public function getSubscription()
    {
        return $this->Subscription;
    }
    /**
     * Set Subscription value
     * @param bool $subscription
     * @return \StructType\IPSideQuery
     */
    public function setSubscription($subscription = null)
    {
        $this->Subscription = $subscription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPSideQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
