<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPReqAppResultRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPReqAppResultRequestType «Запрос на получение ответов на заявления или запросы в ОСП» | ЭП
 * @subpackage Structs
 */
class IPReqAppResultRequestType extends AbstractStructBase
{
    /**
     * The requestKeys
     * Meta informations extracted from the WSDL
     * - documentation: Ключи запросов или заявлений | Ключи запросов, возвращенные веб-сервисом при регистрации запроса или заявления | Ключ объекта,
     * присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxOccurs: unbounded
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int[]
     */
    public $requestKeys;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPReqAppResultRequestType
     * @uses IPReqAppResultRequestType::setRequestKeys()
     * @uses IPReqAppResultRequestType::setSignature()
     * @uses IPReqAppResultRequestType::setId()
     * @param int[] $requestKeys
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct(array $requestKeys = array(), array $signature = array(), $id = null)
    {
        $this
            ->setRequestKeys($requestKeys)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get requestKeys value
     * @return int[]|null
     */
    public function getRequestKeys()
    {
        return $this->requestKeys;
    }
    /**
     * Set requestKeys value
     * @throws \InvalidArgumentException
     * @param int[] $requestKeys
     * @return \StructType\IPReqAppResultRequestType
     */
    public function setRequestKeys(array $requestKeys = array())
    {
        $this->requestKeys = $requestKeys;
        return $this;
    }
    /**
     * Add item to requestKeys value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\IPReqAppResultRequestType
     */
    public function addToRequestKeys($item)
    {
        $this->requestKeys[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPReqAppResultRequestType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPReqAppResultRequestType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IPReqAppResultRequestType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPReqAppResultRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
